#include <SFML/Graphics.hpp>
#include "GUI/CButton.h"
#include "GUI/CTaskSpawnedView.h"
#include "GUI/CTaskListRunningView.h"
#include "GUI/CTaskListSpawnedView.h"
#include "GUI/CMemoryView.h"
#include "GUI/CCoreView.h"
#include <sstream>
#include <iostream>
#include <cstring>
#include "GUI/CGameGUI.h"
#include <SFML/System.hpp>
#include <SFML/System/Time.hpp>

#define NEW_TASK 10

void runTests() {
	CComputer * comp = new CComputer();
	std::cout << "Test:" << std::endl;
	CTestComputer *test = new CTestComputer(comp);
	test->runTests();
	CTestCore * testCore = new CTestCore();
	testCore->runTests();
	CTestProcessor * testProcessor = new CTestProcessor();
	testProcessor->runTests();
	CTestGameGUI * testGUI = new CTestGameGUI();
	testGUI->runTests();

	delete testProcessor;
	delete testCore;
	delete test;
	delete comp;
	delete testGUI;
	
	return;
}

void runGame(void) {
	std::vector <CTask*> * running = 0;
	unsigned int i;
	std::srand(time(NULL));
	CComputer * comp = new CComputer();
	double new_task = NEW_TASK; // za jak dlouho bude novy task

	CGameGUI gui(sf::Vector2u(1000, 600));
	gui.init(comp);
	sf::Event ev;
	int status = 2; //0 - hraje, 1 - pausnuto, 2 - username menu
	string username;

	unsigned int cas = 0, newTask = 0;

	gui.setTime(comp->getTime()); //nastaveni casu v gui
	gui.refresh(); //refresh kvuli zobrazeni casu
	comp->increaseTime(); //prictu sekundu do svyho timu

	while (gui.getWindow()->isOpen())
	{
		while (gui.getWindow()->pollEvent(ev))
		{
			if (ev.type == sf::Event::Closed)
			{
				gui.close();

			}
			if ((ev.type == sf::Event::MouseButtonPressed) && (ev.mouseButton.button == sf::Mouse::Left))
			{
				//std::cout << "LMB pressed" << std::endl;
				int tmp = gui.checkButtons(sf::Mouse::getPosition(gui.getWindowReference()));
				//std::cout << "it caught the event!" << std::endl;
				if (tmp == 1)
				{ // pressed reset button
					cas = 0;
					newTask = 0;
					comp->restart();
					gui.setTime(comp->getTime());
					new_task = NEW_TASK;
				}
				else if (tmp == 2)
				{ // pressed pause button
					if (status == 1)
						status = 0;
					else
						status = 1;
				}
				else if (tmp == 3)
				{ // pressed start button
					status = 1;
					newTask = 0;
					cas = 0;
					gui.refresh();
				}
				gui.refresh();
				//cout << tmp << endl;
			}
			if (ev.type == sf::Event::GainedFocus)
			{
				gui.refresh();
			}
			if (ev.type == sf::Event::TextEntered && status == 2)
			{
				if (ev.text.unicode == '\b' && username.size() > 0)
					username.erase(username.size() - 1, 1);
				else if (ev.text.unicode < 128 && username.size() < 32)
					username += static_cast<char>(ev.text.unicode);

				gui.setUsername(username);
				comp->setName(username);
				gui.refresh();
			}
			if (ev.type == sf::Event::KeyPressed && status == 2 && ev.key.code == sf::Keyboard::Return)
			{
				status = 1;
				newTask = 0;
				cas = 0;
				gui.setPaused(1);
				gui.refresh();
				gui.refresh();
			}
		}
		sf::sleep(sf::milliseconds(10));
		if (status == 0)
			cas += 10;
		if (cas == 1000)
		{ // tady je muj cyklus po sekunde

			if (status == 0)
			{
				running = comp->getRunningTasks();
				for (i = 0; i < running->size(); i++)
				{ //snizeni poctu operaci u bezicich procesu, pripadne ukonceni procesu
					if (running->at(i)->getState() == 1 && running->at(i)->decreaseRest(comp->getProcessLoad(running->at(i)->getID())))
					{
						comp->finishedTask(running->at(i)->getID());
					}
				}
				newTask++;
				if (newTask == (unsigned int)new_task)
				{
					if (comp->getTaskLine()->size() == 15)
					{
						//gui.Close();
						gui.setLost(true);
						comp->setScore();
					}
					else
					{
						newTask = 0;
						comp->newTask();
					}
					if (new_task >= (double)2) new_task -= 0.2;
				}
			}
			gui.setTime(comp->getTime()); //nastaveni casu v gui
			gui.refresh(); //refresh kvuli zobrazeni casu
			comp->increaseTime(); //prictu sekundu do svyho timu
			cas = 0;
		}
		//gui.refresh();
	}
	delete comp;
}

int main(int argc, char* argv[])
{
	if ((argc > 1) && (strcmp(argv[1], "test") == 0))
	{
		runTests();
	}
	else
	{
		runGame();
	}
    return 0;
}
