///////////////////////////////////////////////////////////
//  TTime.h
//  Implementation of the Class CGame
//  Created on:      04-4-2015 21:51:55
//  Original author: Radek
///////////////////////////////////////////////////////////

#if !defined(TTIME_H)
#define TTIME_H

#include <string>

/** Struktura reprezentující čas
 */

struct TTime 
{
	unsigned int m_Minutes; ///< Minuty
	unsigned int m_Seconds; ///< Sekundy
	unsigned int m_Hours; ///<  Hodiny
	/** Konstruktor. Nastaví počáteční čas
	 */
	TTime()
	{
		m_Minutes = 0; m_Seconds = 0; m_Hours = 0;
	};
	/** Nastaví počáteční čas
	 */
	void reset () 
	{
		m_Minutes = 0; m_Seconds = 0; m_Hours = 0;
	};
	/** Přičte sekundu
	 */
	void increase() 
	{ 
		m_Seconds++;
		if ( m_Seconds > 59 ) 
		{
			m_Minutes++;
			m_Seconds = 0;
		}
		if ( m_Minutes > 59 ) 
		{
			m_Hours++;
			m_Minutes = 0;
		}	
	};
	/** Vytvoří string reprezentující aktuální čas
	 */
	std::string get() 
	{
		std::string ret = "";
		if ( m_Hours < 10 ) ret += "0";
		ret += std::to_string(m_Hours) + ":";
		if ( m_Minutes < 10 ) ret += "0";
		ret += std::to_string(m_Minutes) + ":";
		if ( m_Seconds < 10 ) ret += "0";
		ret += std::to_string(m_Seconds);
		return ret;
	};
	/** Vrací počet odehraných minut
	 */
	int getMinutes () 
	{
		return m_Hours * 60 + m_Minutes;
	};
};
#endif // !defined(TTIME_H)
