///////////////////////////////////////////////////////////
//  CTaskView.h
//  Implementation of the Class CTaskView
//  Created on:      04-4-2015 11:30:06
//  Original author: Kuba
///////////////////////////////////////////////////////////

#if !defined CTASKVIEW_H
#define CTASKVIEW_H

#include "CButton.h"


/** Vykresluje proces s informacemi o něm jako obdélník zadané barvy s textem popisu.
 */

class CTaskView : IDrawable
{

public:
	CTaskView(); ///< Prazdny konstruktor
	virtual ~CTaskView(); ///< Destkruktor
    virtual void SetTaskColor(const sf::Color & color);
	/** Konstruktor s parametry
	*	@param taskColor barva ulohy
	*	@param taskID ID ulohy
	*	@param taskInfo informace o uloze
	*	@param font pismo popisu
	*/
    CTaskView(const sf::Color & taskColor, const std::string & taskID, const std::string & taskInfo,
              const sf::Font & font);
    virtual void draw(sf::RenderWindow & window) = 0;
	/** Vykreslujici metoda
	*	@param window reference na okno do ktereho se uloha vykresluje
	*/
    void drawTask(sf::RenderWindow & window);
    virtual const sf::Text& getTextID() const;  ///< Getter ID typu sf::Text
	virtual const int getIntID() const; ///< Getter ID typu int
    virtual void addKillButton(const sf::Vector2f btnSize, unsigned int btnTextSize) = 0;
    virtual void addPauseButton(const sf::Vector2f btnSize, unsigned int btnTextSize) = 0;
    virtual void addRunButton(const sf::Vector2f & runBtnSize, unsigned int textSize) = 0;
    virtual void addIncAndDecrButtons() = 0;
	/** Metoda pridavajici uloze tlacitka pro zvyseni a snizeni poctu vlaken
		@param nextTo souradnice tlacitka vedle ktereho se nachazeji
	*/
    void setIncDecrBut(const sf::Vector2f & nextTo);
    void setSize(const sf::Vector2f & taskSize); ///< Setter velikosti ulohy
    void setPosition(const sf::Vector2f & position); ///< Setter pozice ulohy
    void setTextSize(unsigned int textSize); ///< Setter velikosti textu
    sf::RectangleShape getShape(); ///< Getter ohranicujiciho obdelniku
    virtual bool checkIncBtn(sf::Vector2i) = 0;
    virtual bool checkDecBtn(sf::Vector2i) = 0;
    virtual void increaseThreads(); ///< Metoda zvysujici pocet vlaken
    virtual void decreaseThreads(); ///< Metoda snizujici pcoet vlaken
    virtual void setThreads(int threads); ///< Setter poctu vlaken
    virtual int getThreads() {return m_threadsInt;} ///< Getter poctu vlaken
protected:
	sf::RectangleShape				m_shape; 			///< Ohranicujici obdelnik
	sf::Text 						m_taskID; 			///< ID ulohy
	sf::Text 						m_taskInfo; 		///< Informace o uloze
	CButton * 						m_btnInc; 			///< Ukazatel na tlacitko zvysujici pocet vlaken
	CButton * 						m_btnDecr;  		///< Ukazatel na tlacitko snizujici pocet vlaken
	int 							m_threadsInt = 1; 	///< Ciselne ulozeni poctu vlaken
	sf::Text 						m_numOfThreads; 	///< Textove ulozeni poctu vlaken (proc ucely vykreslovani)
};
#endif // !defined(EA_03D2F6A0_42B5_48d7_A687_680AAE175554__INCLUDED_)
