///////////////////////////////////////////////////////////
//  CTaskView.cpp
//  Implementation of the Class CTaskView
//  Created on:      04-4-2015 11:30:06
//  Original author: Kuba
///////////////////////////////////////////////////////////

#include "CTaskView.h"
#include <sstream>
#include <iostream>


CTaskView::CTaskView(){

}


CTaskView::~CTaskView(){
    delete m_btnDecr;
    delete m_btnInc;
}


CTaskView::CTaskView(const sf::Color & taskColor, const std::string & taskId, const std::string & taskInf, const sf::Font & font) :
			m_taskID(taskId, font), m_taskInfo(taskInf, font), m_btnInc(NULL), m_btnDecr(NULL), m_numOfThreads("1", font)
{
    m_shape.setFillColor(taskColor);
    m_taskID.setColor(sf::Color::Black);
    m_taskInfo.setColor(sf::Color::Black);
}


void CTaskView::SetTaskColor(const sf::Color & color)
{
    m_shape.setFillColor(color);
}


void CTaskView::drawTask(sf::RenderWindow & window)
{
    window.draw(m_shape);
    window.draw(m_taskID);
    window.draw(m_taskInfo);
}


const sf::Text& CTaskView::getTextID() const
{
    return m_taskID;
}

const int CTaskView::getIntID() const
{
	return std::stoi(m_taskID.getString().toAnsiString());
}


void CTaskView::setSize(const sf::Vector2f & taskSize)
{
    m_shape.setSize(taskSize);
}


void CTaskView::setPosition(const sf::Vector2f & position)
{
    m_shape.setPosition(position);
    m_taskID.setPosition(position.x + 1.0, position.y + 1.0);
    sf::FloatRect rect = m_taskID.getGlobalBounds();
    m_taskInfo.setPosition(rect.left + rect.width + 2.0, position.y + 1.0);
}


void CTaskView::setTextSize(unsigned int textSize)
{
    m_taskID.setCharacterSize(textSize);
    m_taskInfo.setCharacterSize(textSize);
}

sf::RectangleShape CTaskView::getShape() {
	return m_shape;
}


void CTaskView::setIncDecrBut(const sf::Vector2f & nextTo)
{
	if (m_btnInc != NULL)
        delete m_btnInc;
    
	if (m_btnDecr != NULL)
        delete m_btnDecr;

    sf::FloatRect shapeRect = m_shape.getGlobalBounds();
    m_btnInc = new CButton(sf::Vector2f(1,1), 10.0/20 * shapeRect.height, "+", *(m_taskID.getFont()));
    m_btnDecr = new CButton(sf::Vector2f(1,1), 10.0/20 * shapeRect.height, "-", *(m_taskID.getFont()));
    sf::FloatRect btnIncRect = m_btnInc->getShape().getGlobalBounds();

    m_btnInc->setPosition(sf::Vector2f(nextTo.x - btnIncRect.width - 1, nextTo.y + 1.0/20 * shapeRect.height));

    btnIncRect = m_btnInc->getShape().getGlobalBounds();
    m_btnDecr->setSize(sf::Vector2f(btnIncRect.width, btnIncRect.height));
    m_btnDecr->setPosition(sf::Vector2f(btnIncRect.left, btnIncRect.top + btnIncRect.height + (1.0/20 * shapeRect.height)));

    m_numOfThreads.setCharacterSize(16.0/20.0 * shapeRect.height);
    m_numOfThreads.setColor(sf::Color::Black);
    sf::Vector2f numPos(btnIncRect.left - 8, shapeRect.top + 1.0 / 20 * shapeRect.height);
    m_numOfThreads.setPosition(numPos);
    m_numOfThreads.setPosition(numPos.x, numPos.y - (m_numOfThreads.getGlobalBounds().top - numPos.y));
}


void CTaskView::increaseThreads() {
    m_threadsInt++;
    m_numOfThreads.setString(to_string(m_threadsInt));
}


void CTaskView::decreaseThreads() {
    if(m_threadsInt>1)
		m_threadsInt--;
    m_numOfThreads.setString(to_string(m_threadsInt));
}


void CTaskView::setThreads(int i) {
    m_threadsInt = i;
    m_numOfThreads.setString(to_string(m_threadsInt));
}

