///////////////////////////////////////////////////////////
//  CTaskInTaskLineView.h
//  Implementation of the Class CTaskInTaskLineView
//  Created on:      04-4-2015 11:30:06
//  Original author: Kuba
///////////////////////////////////////////////////////////

#if !defined CTASKSPAWNEDVIEW_H
#define CTASKSPAWNEDVIEW_H

#include "CTaskView.h"
#include <string>

/** Vykresluje nově vytvořený proces. Funkčnost CTaskView rozšiřuje přidáním tlačítek pro spuštění a změnu počtu
 * vláken, kterých proces využije.
 */

class CTaskSpawnedView : public CTaskView
{

public:
	CTaskSpawnedView(); ///< Prazdny konstruktor
	virtual ~CTaskSpawnedView(); ///< Destruktor
	/** Metoda pridavajici uloze tlacitko spustit
		@param runBtnSize velikost tlacitka
		@param textSize velikost textu
	*/
	void addRunButton(const sf::Vector2f & runBtnSize, unsigned int textSize);
	virtual void addIncAndDecrButtons(); ///< Metoda pridavajici uloze tlacitka pro zvyseni a snizeni poctu vlaken
	/** Konstruktor s parametry
		@param taskColor barva ulohy
		@param taskID ID ulohy
		@param taskInfo informace o uloze
		@param font pismo textu
	*/
	CTaskSpawnedView(const sf::Color & taskColor, const std::string & taskID, const std::string & taskInfo,
                     const sf::Font & font);
	/** Konstruktor s parametry
		@param taskColor barva ulohy
		@param taskID ID ulohy
		@param taskInfo informace o uloze
		@param font pismo textu
		@param canRun udaj zda lze ulohu spustit
	*/
	CTaskSpawnedView(const sf::Color & taskColor, const std::string & taskID, const std::string & taskInfo,
                   const sf::Font & font, bool canRun);
	/** Vykreslujici metoda
	*	@param window reference na okno do ktereho se tlacitko vykresluje
	*/
    virtual void draw(sf::RenderWindow & window);
	virtual void addKillButton(const sf::Vector2f btnSize, unsigned int btnTextSize) {};
	virtual void addPauseButton(const sf::Vector2f btnSize, unsigned int btnTextSize) {};
	/** Metoda pro kontrolu kliknuti tlacitka spustit
		@param coords souradnice kliknuti
	*/
    bool checkRunBtn(sf::Vector2i coords);
	/** Metoda pro kontrolu kliknuti tlacitka zvyseni vlaken
	@param coords souradnice kliknuti
	*/
    virtual bool checkIncBtn(sf::Vector2i coords);
	/** Metoda pro kontrolu kliknuti tlacitka snizeni vlaken
	@param coords souradnice kliknuti
	*/
    virtual bool checkDecBtn(sf::Vector2i coords);
	bool getCanRun(); ///< Getter udaje o schopnosti spustit ulohu
private:
	CButton * 			m_btnRun;		///< ukazatel na tlacitko spustit
	bool 				m_canRun = 1;	// 0 - nemuze bezet kvuli zavislostem, 1 - nic nebrani spusteni ///< udaj zda lze ulohu spustit

};
#endif // !defined CTASKSPAWNEDVIEW_H
