///////////////////////////////////////////////////////////
//  CTaskInTaskLineView.cpp
//  Implementation of the Class CTaskInTaskLineView
//  Created on:      04-4-2015 11:30:06
//  Original author: Kuba
///////////////////////////////////////////////////////////

#include "CTaskSpawnedView.h"
#include <SFML/Graphics/Color.hpp>
#include <iostream>
//#include "CRunButton.h"

CTaskSpawnedView::CTaskSpawnedView()
{

}


CTaskSpawnedView::~CTaskSpawnedView()
{
    delete m_btnRun;
}


CTaskSpawnedView::CTaskSpawnedView(const sf::Color & taskColor, const std::string & taskID, const std::string & taskInfo, const sf::Font & font) :
			CTaskView(taskColor, taskID, taskInfo, font), m_btnRun(NULL)
{

}


CTaskSpawnedView::CTaskSpawnedView(const sf::Color & taskColor, const std::string & taskID, const std::string & taskInfo, const sf::Font & font, bool _canRun) :
			CTaskView(taskColor, taskID, taskInfo, font), m_btnRun(NULL)
{
	m_canRun = _canRun;
}


void CTaskSpawnedView::addRunButton(const sf::Vector2f & runBtnSize, unsigned int textSize)
{
    sf::FloatRect shapeRec = m_shape.getGlobalBounds();
    if (m_btnRun != NULL)
        delete m_btnRun;

	if (m_canRun)
	{
		m_btnRun = new CButton(sf::Vector2f(shapeRec.left + shapeRec.width - runBtnSize.x - 1.0, shapeRec.top + 1.0), textSize,
			"Spustit", *(m_taskID.getFont()));
	}
	else
	{
		m_btnRun = new CButton(sf::Vector2f(shapeRec.left + shapeRec.width - runBtnSize.x - 1.0, shapeRec.top + 1.0), textSize,
			"Spustit", *(m_taskID.getFont()), sf::Color(135,135,135,255));
	}

    sf::FloatRect rect = m_btnRun->getText().getGlobalBounds();
    m_btnRun->setPosition(sf::Vector2f(shapeRec.left + shapeRec.width - rect.width - 3.0, shapeRec.top));

}


void CTaskSpawnedView::addIncAndDecrButtons()
{
    CTaskView::setIncDecrBut(m_btnRun->getShape().getPosition());
}


void CTaskSpawnedView::draw(sf::RenderWindow & window)
{
    CTaskView::drawTask(window);
    m_btnRun->draw(window);
    m_btnInc->draw(window);
    m_btnDecr->draw(window);
    window.draw(m_numOfThreads);
}


bool CTaskSpawnedView::checkRunBtn(sf::Vector2i coords) {
    return m_btnRun->checkClicked(sf::Vector2f(coords.x, coords.y));
}


bool CTaskSpawnedView::checkIncBtn(sf::Vector2i coords) {
    return m_btnInc->checkClicked(sf::Vector2f(coords.x, coords.y));
}


bool CTaskSpawnedView::checkDecBtn(sf::Vector2i coords) {
    return m_btnDecr->checkClicked(sf::Vector2f(coords.x, coords.y));
}


bool CTaskSpawnedView::getCanRun() {
	return m_canRun;
}


