///////////////////////////////////////////////////////////
//  CRunningTaskView.h
//  Implementation of the Class CRunningTaskView
//  Created on:      04-4-2015 11:30:05
//  Original author: Kuba
///////////////////////////////////////////////////////////

#if !defined CTASKRUNNINGVIEW_H
#define CTASKRUNNINGVIEW_H

#include "CTaskView.h"

/** Vykresluje běžící/stojící proces. Funkčnost CTaskView rozšiřuje přidáním tlačítek pro zastavení/spuštění a
 *  zabití procesu.
 */

class CTaskRunningView : public CTaskView
{

public:
	CTaskRunningView(); ///< Prazdny konstruktor
	virtual ~CTaskRunningView(); ///< Destruktor
	/** Konstruktor s parametry
		@param taskColor barva ulohy
		@param m_taskID ID ulohy
		@param m_taskInfo informace o uloze
		@param font pismo textu
	*/
    CTaskRunningView(const sf::Color & taskColor, const std::string & taskId, const std::string & taskInf,
                     const sf::Font & font, bool paused);
	/** Metoda pridavajici uloze tlacitko ukoncit
	@param runBtnSize velikost tlacitka
	@param textSize velikost textu
	*/
    virtual void addKillButton(const sf::Vector2f btnSize, unsigned int btnTextSize);
	/** Metoda pridavajici uloze tlacitko pozastavit/znovuspustit
	@param runBtnSize velikost tlacitka
	@param textSize velikost textu
	*/
    virtual void addPauseButton(const sf::Vector2f btnSize, unsigned int btnTextSize);
    virtual void addRunButton(const sf::Vector2f & runBtnSize, unsigned int textSize) {}
    virtual void addIncAndDecrButtons(); ///< Metoda pridavajici uloze tlacitka pro zvyseni a snizeni poctu vlaken
	/** Vykreslujici metoda
	*	@param window reference na okno do ktereho se tlacitko vykresluje
	*/
    virtual void draw(sf::RenderWindow & window);
	/** Metoda pro kontrolu kliknuti tlacitka ukoncit
	@param coords souradnice kliknuti
	*/
    bool checkKillBtn(sf::Vector2i coords);
	/** Metoda pro kontrolu kliknuti tlacitka pozastavit/znovustpustit
	@param coords souradnice kliknuti
	*/
    bool checkPauseBtn(sf::Vector2i coords);
    bool checkPause() {return m_paused;}; ///< metoda kontrolujici v jakem stavu se uloha nachazi
    void setPaused(bool _paused) {m_paused = _paused;}
	/** Metoda pro kontrolu kliknuti tlacitka zvyseni vlaken
	@param coords souradnice kliknuti
	*/
    virtual bool checkIncBtn(sf::Vector2i coords);
	/** Metoda pro kontrolu kliknuti tlacitka snizeni vlaken
	@param coords souradnice kliknuti
	*/
    virtual bool checkDecBtn(sf::Vector2i coords);
private:
	CButton * 		m_btnKill; 		///< Ukazatel na tlacitko ukoncit
	CButton * 		m_btnPause; 	///< Ukazatel na tlacitko pozastavit/znovuspustit
	sf::Text 		m_cpuID; 		///< ???
	bool 			m_paused; 		// 0 - running, 1 - paused
};
#endif // !defined CTASKRUNNINGVIEW_H
