///////////////////////////////////////////////////////////
//  CRunningTaskView.cpp
//  Implementation of the Class CRunningTaskView
//  Created on:      04-4-2015 11:30:05
//  Original author: Kuba
///////////////////////////////////////////////////////////

#include "CTaskRunningView.h"
#include <iostream>

CTaskRunningView::CTaskRunningView()
{

}


CTaskRunningView::~CTaskRunningView()
{
    delete m_btnKill;
    delete m_btnPause;
}


CTaskRunningView::CTaskRunningView(const sf::Color & taskColor, const std::string & taskId, const std::string & taskInf, const sf::Font & font, bool m_paused) :
                  CTaskView(taskColor, taskId, taskInf, font), m_btnKill(NULL), m_btnPause(NULL), m_paused(m_paused)
{

}


void CTaskRunningView::addKillButton(const sf::Vector2f btnSize, unsigned int btnTextSize)
{
    sf::FloatRect shapeRect = m_shape.getGlobalBounds();

    if(m_btnKill != NULL)
        delete m_btnKill;
    
	m_btnKill = new CButton(sf::Vector2f(shapeRect.left + shapeRect.width - btnSize.x - 1.0, shapeRect.top + 1.0), m_shape.getGlobalBounds().height,
                          "X", *(m_taskID.getFont()));
    m_btnKill->setTextColor(sf::Color::Blue);
    sf::FloatRect textRect = m_btnKill->getText().getGlobalBounds();
    m_btnKill->setPosition(sf::Vector2f(shapeRect.left + shapeRect.width - textRect.width - 1.0, CMathHelp::FindCenteringPosition(shapeRect.top, shapeRect.height, textRect.height)));
}


void CTaskRunningView::addPauseButton(const sf::Vector2f btnSize, unsigned int btnTextSize)
{
    if(m_btnPause != NULL)
        delete m_btnPause;

    m_btnPause = new CButton(sf::Vector2f(m_btnKill->getShape().getPosition().x - btnSize.x - 2.0, m_shape.getGlobalBounds().top + 1.0), m_shape.getGlobalBounds().height,
                           ((m_paused) ? "Unpause" : "Pause"), *(m_taskID.getFont()));
    sf::FloatRect rect = m_btnPause->getText().getGlobalBounds();
    m_btnPause->setPosition(sf::Vector2f(m_btnKill->getShape().getPosition().x - rect.width - 5.0, m_shape.getGlobalBounds().top + 1.0));
}


void CTaskRunningView::addIncAndDecrButtons()
{
    CTaskView::setIncDecrBut(m_btnPause->getShape().getPosition());
}


void CTaskRunningView::draw(sf::RenderWindow & window)
{
    CTaskView::drawTask(window);
    m_btnKill->draw(window);
    m_btnPause->draw(window);
    if(m_paused)
    {
        m_btnInc->draw(window);
        m_btnDecr->draw(window);
        window.draw(m_numOfThreads);
    }
}


bool CTaskRunningView::checkKillBtn(sf::Vector2i coords)
{
    return m_btnKill->checkClicked(sf::Vector2f(coords.x, coords.y));
}


bool CTaskRunningView::checkPauseBtn(sf::Vector2i coords)
{
    return m_btnPause->checkClicked(sf::Vector2f(coords.x, coords.y));
}


bool CTaskRunningView::checkIncBtn(sf::Vector2i coords)
{
    if(m_paused)
      return m_btnInc->checkClicked(sf::Vector2f(coords.x, coords.y));
    return false;
}


bool CTaskRunningView::checkDecBtn(sf::Vector2i coords)
{
    if(m_paused)
        return m_btnDecr->checkClicked(sf::Vector2f(coords.x, coords.y));
    return false;
}

