#ifndef CTASKLISTVIEW_H
#define CTASKLISTVIEW_H

#include <vector>
#include "CTaskSpawnedView.h"
#include "IDrawable.h"
#include "../CComputer.h"

#define DEFAULT_NUM_OF_NODES 15
#define BTN_RATIO_AGAINST_WIDTH 9
#define BORDER_THICKNESS 2

/** Vykresluje seznam úloh. Kapacita rovná 0 indikuje seznam s neomezenou kapacitou a zobrazuje pouze vložené procesy.
 *  Nenulová kapacita se projeví vykreslením volných polí v seznamu
 */
class CTaskListView : public IDrawable
{
	friend class CTestTaskListView;
    public:
        CTaskListView(); ///< Prazdny konstruktor
        virtual ~CTaskListView(); ///< Destruktor
        virtual void draw(sf::RenderWindow & window) = 0;
		/** Metoda pro pridani ulohy do seznamu
		*	@param newTask uloha pro pridani
		*/
        void addTask(CTaskView * newTask);
		/** Metoda pro odstraneni ulohy ze seznamu
		*	@param taskID ID ulohy pro odstraneni
		*/
        void deleteTask(int taskID);
		/** Konstruktor s parametry
		*	@param m_position pozice
		*	@param maxHeight vyska seznamu
		*	@param width sirka seznamu
		*	@param capacity maximalni pocet uloh v seznamu
		*/
        CTaskListView(sf::Vector2f position, float maxHeight, float width, unsigned int capacity = 0);
        int getCount(); ///< Getter poctu uloh v seznamu
        std::vector<CTaskView*> getTasks(); ///< Getter seznamu uloh
        virtual std::vector<CTaskView*> getSpawnedTasks() = 0;
        virtual std::vector<CTaskView*> getRunningTasks() = 0;
        sf::Vector2f getPosition() {return m_position;}; ///< Getter pozice seznamu uloh
		/** Metoda pro aktualizaci zobrazovanych dat
		*	@param comp ukazatel na CComputer obsahujici data
		*	@param font pismo textu
		*/
        virtual void update(CComputer *, sf::Font&) {};
		float getNodeHeight(); ///< Vraci vypoctenou vysku jedne ulohy
    protected:
        std::vector<CTaskView*> 					m_tasks; 			///< Vector uloh
        sf::Vector2f 								m_position; 		///< Pozice seznamu
        unsigned int 								m_capacity; 		///< Kapacita (maximalni pocet uloh)
		float 										m_maxHeight; 		///< Vyska seznamu
		float 										m_width;			///< Sirka seznamu
		float 										m_nodeHeight; 		///< Aktualni vyska jedne ulohy, zavisi na poctu uloh v seznamu
		bool 										m_listChanged;		///< Udaj zda byl seznam zmenen
        void CountNodeHeight(); ///< Metoda pro vypocet vysky jedne ulohy
		/** Vykreslujici metoda
		*	@param window reference na okno do ktereho se seznam vykresluje
		*/
        void drawTaskList(sf::RenderWindow & window);
        void setTasksPositions(); ///< Metoda urcujici pozici jednotlivych uloh v seznamu
};

#endif // CTASKLISTVIEW_H
