#include "CTaskListView.h"
#include <sstream>
#include <iostream>


CTaskListView::CTaskListView()
{
    //ctor
}


CTaskListView::~CTaskListView()
{
    for(vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
        delete *it;
}


CTaskListView::CTaskListView(sf::Vector2f position, float maxHeight, float width, unsigned int capacity) :
    m_position(position), m_capacity(capacity), m_maxHeight(maxHeight), m_width(width), m_listChanged(true)
{
	this->CountNodeHeight();
}


void CTaskListView::CountNodeHeight()
{
    int taskCount = (int)(m_tasks.size());
    int usedCapacity = ((m_capacity != 0) ? m_capacity : ((taskCount > DEFAULT_NUM_OF_NODES) ? taskCount : DEFAULT_NUM_OF_NODES));
    m_nodeHeight = ((m_maxHeight - BORDER_THICKNESS) / usedCapacity);
}


void CTaskListView::setTasksPositions()
{
    float actY = m_position.y + BORDER_THICKNESS;
    CountNodeHeight();
    for (vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
    {
        (*it)->setTextSize((unsigned int)(m_nodeHeight - 3.0 - BORDER_THICKNESS));
        (*it)->setSize(sf::Vector2f(m_width, m_nodeHeight - BORDER_THICKNESS));
        (*it)->setPosition(sf::Vector2f(m_position.x, actY));
        actY += m_nodeHeight;
    }
}


void CTaskListView::drawTaskList(sf::RenderWindow & window)
{
    sf::RectangleShape listBorder(sf::Vector2f(m_width, m_maxHeight - 2 * BORDER_THICKNESS));
    listBorder.setPosition(sf::Vector2f(m_position.x, m_position.y + BORDER_THICKNESS));
    listBorder.setFillColor(sf::Color::Transparent);
    listBorder.setOutlineColor(sf::Color::Black);
    listBorder.setOutlineThickness(BORDER_THICKNESS);
    window.draw(listBorder);
    float actY = m_position.y + BORDER_THICKNESS;
    sf::RectangleShape border(sf::Vector2f(m_width, m_nodeHeight - BORDER_THICKNESS));
    border.setOutlineColor(sf::Color::Black);
    border.setOutlineThickness(BORDER_THICKNESS);
    border.setFillColor(sf::Color::Transparent);
    for (vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
    {
        (*it)->draw(window);
        border.setPosition(m_position.x, actY);
        window.draw(border);
        actY += m_nodeHeight;
    }
    while (actY < m_position.y + m_maxHeight && m_capacity != 0)
    {
        border.setPosition(m_position.x, actY);
        window.draw(border);
        actY += m_nodeHeight;
    }
}


void CTaskListView::addTask(CTaskView * newTask)
{
    m_tasks.push_back(newTask);
    m_listChanged = true;
}


void CTaskListView::deleteTask(int taskID)
{
    stringstream ss;
    int helpID;
    for (vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
    {
        ss << (*it)->getTextID().getString().toAnsiString();
        ss >> helpID;
        if(helpID == taskID)
        {
            m_tasks.erase(it);
            m_listChanged = true;
            break;
        }
    }
}


int CTaskListView::getCount()
{
    return m_tasks.size();
}


std::vector<CTaskView*> CTaskListView::getTasks()
{
    return m_tasks;
}


float CTaskListView::getNodeHeight()
{
	return m_nodeHeight;
}
