#ifndef CTASKLISTSPAWNEDVIEW_H
#define CTASKLISTSPAWNEDVIEW_H

#include "CTaskListView.h"
#include "CTaskSpawnedView.h"
#include "../CComputer.h"


class CTaskListSpawnedView;

class CTestTaskListSpawnedView
{
public:
	CTestTaskListSpawnedView();
	~CTestTaskListSpawnedView();
	void runTests();
private:
	CTaskListSpawnedView *		m_test;
	sf::Font					m_font;
	void testAddTask();
	void testDeleteTask();
};

/** Vykresluje seznam nově vytvořených procesů. Kapacita seznamu rovna 15.
 */

class CTaskListSpawnedView : public CTaskListView
{
	friend class CTestTaskListSpawnedView;
    public:
        CTaskListSpawnedView(); ///< Prazdny konstruktor
        virtual ~CTaskListSpawnedView(); ///< Destruktor
		/** Vykreslujici metoda
		*	@param window reference na okno do ktereho se seznam vykresluje
		*/
        virtual void draw(sf::RenderWindow & window);
		/** Konstruktor s parametry
		*	@param position pozice
		*	@param maxHeight vyska seznamu
		*	@param width sirka seznamu
		*/
        CTaskListSpawnedView(sf::Vector2f position, float maxHeight, float width);
        virtual std::vector<CTaskView*> getSpawnedTasks(); ///< vraci ulohy ve fronte
        virtual std::vector<CTaskView*> getRunningTasks() {std::vector<CTaskView*> dummy; return dummy;} // vraci dummy seznam (metoda existuje pouze z duvodu dedeni)
		/** Metoda pro aktualizaci zobrazovanych dat
		*	@param comp ukazatel na CComputer obsahujici data
		*	@param font pismo pro text
		*/
        void update(CComputer *, sf::Font&);
    protected:
    private:
};

#endif // CTASKLISTSPAWNEDVIEW_H
