#include "CTaskListSpawnedView.h"

#define MAX_NODES 15
#include <iostream>
#include <string>
#include <map>

CTaskListSpawnedView::CTaskListSpawnedView()
{
    //ctor
}


CTaskListSpawnedView::~CTaskListSpawnedView()
{
   //dtor
}


CTaskListSpawnedView::CTaskListSpawnedView(sf::Vector2f position, float maxHeight, float width) :
    CTaskListView(position, maxHeight, width, MAX_NODES)
{

}


void CTaskListSpawnedView::draw(sf::RenderWindow & window)
{
    CTaskListView::setTasksPositions();
    if(m_listChanged)
    {
        CTaskSpawnedView * tempTaskSp;
        CTaskListView::CountNodeHeight();
		for (vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
		{
			tempTaskSp = dynamic_cast<CTaskSpawnedView*>(*it);
			tempTaskSp->addRunButton(sf::Vector2f(m_width / BTN_RATIO_AGAINST_WIDTH, m_nodeHeight - 2.0), (unsigned int)(m_nodeHeight - 2));
			tempTaskSp->addIncAndDecrButtons();
        }
        m_listChanged = false;
    }

    CTaskListView::drawTaskList(window);
}


std::vector<CTaskView*> CTaskListSpawnedView::getSpawnedTasks()
{
    return m_tasks;
}


void CTaskListSpawnedView::update(CComputer * comp, sf::Font& font)
{
		
    map<int, int> threadsMap;
    for (unsigned int i = 0; i<m_tasks.size(); i++)
		{
        threadsMap[m_tasks.at(i)->getIntID()] = m_tasks.at(i)->getThreads();
    }

		for(vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
		{
    	  delete *it;
		}
    m_tasks.clear();

    for (unsigned int i = 0; i<comp->getTaskLine()->size(); i++)
	{
        int ID = comp->getTaskLine()->at(i)->getID();
        string name = comp->getTaskLine()->at(i)->getName();
        int priority = comp->getTaskLine()->at(i)->getPriority();
		if (comp->getTaskLine()->at(i)->getDependences().size() == 0 && (comp->getMaxMemory() - comp->getMemory()) > comp->getTaskLine()->at(i)->getMemory())
		{
			addTask(new CTaskSpawnedView(sf::Color::Cyan,
				to_string(ID),
				" | Priorita: " + to_string(priority) +
				" | Operaci: " + to_string(comp->getTaskLine()->at(i)->getRest()) + "/" + to_string(comp->getTaskLine()->at(i)->getMaxSecond()) +
				" | Pamet: " + to_string(comp->getTaskLine()->at(i)->getMemory()), font, true));
		}
		else
		{
			addTask(new CTaskSpawnedView(sf::Color::Cyan, 
				to_string(ID),
				" | Priorita: " + to_string(priority) +
				" | Operaci: " + to_string(comp->getTaskLine()->at(i)->getRest()) + "/" + to_string(comp->getTaskLine()->at(i)->getMaxSecond()) +
				" | Pamet: " + to_string(comp->getTaskLine()->at(i)->getMemory()), font, false));
		}
    }
    for(unsigned int i=0; i<m_tasks.size(); i++)
	{
        int id = m_tasks.at(i)->getIntID();
        map<int,int>::iterator it;
        it = threadsMap.find(id);
        if(!(it == threadsMap.end()))
		{
            m_tasks.at(i)->setThreads(it->second);
        }
    }
    m_listChanged = true;
}


CTestTaskListSpawnedView::CTestTaskListSpawnedView()
{
	m_test = new CTaskListSpawnedView();
	m_font.loadFromFile("arial.ttf");
}


CTestTaskListSpawnedView::~CTestTaskListSpawnedView()
{
	delete m_test;
}


void CTestTaskListSpawnedView::runTests()
{
	testAddTask();
	testDeleteTask();
}


void CTestTaskListSpawnedView::testAddTask()
{
	if (!m_test->m_tasks.empty())
		m_test->m_tasks.clear();

	m_test->addTask(new CTaskSpawnedView(sf::Color::Red, "1", "Info 1", m_font));
	m_test->addTask(new CTaskSpawnedView(sf::Color::Blue, "2", "Info 2", m_font));
	m_test->addTask(new CTaskSpawnedView(sf::Color::Green, "3", "Info 3", m_font));
	m_test->addTask(new CTaskSpawnedView(sf::Color::Black, "4", "Info 4", m_font));

	if (m_test->m_tasks.size() != 4)
	{
		std::cout << "CTaskListSpawnedView/addTask() fail!" << std::endl;
		return;
	}
	std::cout << "CTaskListSpawnedView/addTask() success!" << std::endl;
}


void CTestTaskListSpawnedView::testDeleteTask()
{
	if (!m_test->m_tasks.empty())
		m_test->m_tasks.clear();

	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Red, "1", "Info 1", m_font));
	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Blue, "2", "Info 2", m_font));
	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Green, "3", "Info 3", m_font));
	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Black, "4", "Info 4", m_font));

	m_test->deleteTask(2);

	if (!(m_test->m_tasks.size() != 3))
	{
		std::cout << "CTaskListSpawnedView/deleteTask() fail!" << std::endl;
		return;
	}

	m_test->deleteTask(4);

	if (!(m_test->m_tasks.size() != 2))
	{
		std::cout << "CTaskListSpawnedView/deleteTask() fail!" << std::endl;
		return;
	}
	std::cout << "CTaskListSpawnedView/deleteTask() success!" << std::endl;
}
