#ifndef CTASKLISTRUNNINGVIEW_H
#define CTASKLISTRUNNINGVIEW_H

#include "CTaskListView.h"
#include "CTaskRunningView.h"
#include "../CComputer.h"

class CTaskListRunningView;

class CTestTaskListRunningView
{
public:
	CTestTaskListRunningView();
	~CTestTaskListRunningView();
	void runTests();
private:
	CTaskListRunningView *		m_test;
	sf::Font					m_font;
	void testAddTask();
	void testDeleteTask();
};



/** Vykresluje seznam spuštěných/pausnutých procesů. Kapacita = 0.
 */

class CTaskListRunningView : public CTaskListView
{
	friend class CTestTaskListRunningView;
    public:
        CTaskListRunningView(); ///< Prazdny konstruktor
        virtual ~CTaskListRunningView(); ///< Destruktor
		/** Vykreslujici metoda
		*	@param window reference na okno do ktereho se tlacitko vykresluje
		*/
        virtual void draw(sf::RenderWindow & window);
		/** Konstruktor s parametry
		*	@param position pozice
		*	@param maxHeight vyska seznamu
		*	@param width sirka seznamu
		*/
        CTaskListRunningView(sf::Vector2f position, float maxHeight, float width);
        virtual std::vector<CTaskView*> getSpawnedTasks() {std::vector<CTaskView*> dummy; return dummy;}; // vraci dummy seznam (metoda existuje pouze z duvodu dedeni)
        virtual std::vector<CTaskView*> getRunningTasks(); ///< vraci ulohy v seznamu spustenych uloh
		/** Metoda pro aktualizaci zobrazovanych dat
		*	@param comp ukazatel na CComputer obsahujici data
		*	@param font pismo pro text
		*/
        void update(CComputer *, sf::Font&);
    protected:
    private:
};

#endif // CTASKLISTRUNNINGVIEW_H
