#include "CTaskListRunningView.h"
#include <string>

CTaskListRunningView::CTaskListRunningView()
{
    //ctor
}

CTaskListRunningView::~CTaskListRunningView()
{
    //dtor
}

CTaskListRunningView::CTaskListRunningView(sf::Vector2f position, float maxHeight, float width) :
    CTaskListView(position, maxHeight, width)
{

}

void CTaskListRunningView::draw(sf::RenderWindow & window)
{
    CTaskListView::setTasksPositions();
    if (m_listChanged)
    {
        CTaskListView::CountNodeHeight();
        for (vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
        {
            (*it)->addKillButton(sf::Vector2f(m_width / BTN_RATIO_AGAINST_WIDTH / 3, m_nodeHeight - 2.0), (unsigned int)(m_nodeHeight - 8.0));
            (*it)->addPauseButton(sf::Vector2f(m_width / BTN_RATIO_AGAINST_WIDTH, m_nodeHeight - 2.0), (unsigned int)(m_nodeHeight - 8.0));
            (*it)->addIncAndDecrButtons();
        }
        m_listChanged = false;
    }
    CTaskListView::drawTaskList(window);
}

std::vector<CTaskView*> CTaskListRunningView::getRunningTasks()
{
    return m_tasks;
}

void CTaskListRunningView::update(CComputer * comp, sf::Font & font)
{
	map<int, int> threadsMap;
	for (unsigned int i = 0; i<m_tasks.size(); i++)
	{
		threadsMap[m_tasks.at(i)->getIntID()] = m_tasks.at(i)->getThreads();
	}

	for(vector<CTaskView*>::iterator it = m_tasks.begin(); it != m_tasks.end(); ++it)
	{
  	  delete *it;
	}    
  m_tasks.clear();
 
	for (unsigned int i=0; i<comp->getRunningTasks()->size(); i++)
	{
        if(comp->getRunningTasks()->at(i)->getState() == 0)
		{
            addTask(new CTaskRunningView(sf::Color::Red,
			to_string(comp->getRunningTasks()->at(i)->getID()),
            " | Priorita: " + to_string(comp->getRunningTasks()->at(i)->getPriority()) +
			" | Operaci: " + to_string(comp->getRunningTasks()->at(i)->getRest()) + "/" + to_string(comp->getRunningTasks()->at(i)->getMaxSecond()) +
            " | Pamet: " + to_string(comp->getRunningTasks()->at(i)->getMemory()),
            font, 1));
        }
        else if (comp->getRunningTasks()->at(i)->getState() == 1)
		{
            addTask(new CTaskRunningView(sf::Color::Green,
			to_string(comp->getRunningTasks()->at(i)->getID()),
            " | Priorita: " + to_string(comp->getRunningTasks()->at(i)->getPriority()) +
			" | Operaci: " + to_string(comp->getRunningTasks()->at(i)->getRest()) + "/" + to_string(comp->getRunningTasks()->at(i)->getMaxSecond()) +
            " | Pamet: " + to_string(comp->getRunningTasks()->at(i)->getMemory()),
            font, 0));
        }
    }

	for (unsigned int i = 0; i<m_tasks.size(); i++)
	{
		int id = m_tasks.at(i)->getIntID();
		map<int, int>::iterator it;
		it = threadsMap.find(id);
		if (!(it == threadsMap.end()))
		{
			m_tasks.at(i)->setThreads(it->second);
		}
	}
}


CTestTaskListRunningView::CTestTaskListRunningView()
{
	m_test = new CTaskListRunningView();
	m_font.loadFromFile("arial.ttf");
}


CTestTaskListRunningView::~CTestTaskListRunningView()
{
	delete m_test;
}


void CTestTaskListRunningView::runTests()
{
	testAddTask();
	testDeleteTask();
}


void CTestTaskListRunningView::testAddTask()
{
	if (!m_test->m_tasks.empty())
		m_test->m_tasks.clear();

	m_test->addTask(new CTaskRunningView(sf::Color::Red, "1", "Info 1", m_font, 0));
	m_test->addTask(new CTaskRunningView(sf::Color::Blue, "2", "Info 2", m_font, 1));
	m_test->addTask(new CTaskRunningView(sf::Color::Green, "3", "Info 3", m_font, 0));
	m_test->addTask(new CTaskRunningView(sf::Color::Black, "4", "Info 4", m_font, 1));

	if (m_test->m_tasks.size() != 4)
	{
		std::cout << "CTaskListRunningView/addTask() fail!" << std::endl;
		return;
	}
	std::cout << "CTaskListRunningView/addTask() success!" << std::endl;
}


void CTestTaskListRunningView::testDeleteTask()
{
	if (!m_test->m_tasks.empty())
		m_test->m_tasks.clear();

	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Red, "1", "Info 1", m_font));
	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Blue, "2", "Info 2", m_font));
	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Green, "3", "Info 3", m_font));
	m_test->m_tasks.push_back(new CTaskSpawnedView(sf::Color::Black, "4", "Info 4", m_font));

	m_test->deleteTask(2);

	if (!(m_test->m_tasks.size() != 3))
	{
		std::cout << "CTaskListSpawnedView/deleteTask() fail!" << std::endl;
		return;
	}

	m_test->deleteTask(4);

	if (!(m_test->m_tasks.size() != 2))
	{
		std::cout << "CTaskListSpawnedView/deleteTask() fail!" << std::endl;
		return;
	}
	std::cout << "CTaskListSpawnedView/deleteTask() success!" << std::endl;
}
