#ifndef CPLAYBUTTONVIEW_H
#define CPLAYBUTTONVIEW_H

#include "IDrawable.h"
#include "CMathHelp.h"

using namespace sf;

/** Tlacitko pro spusteni/pozastaveni cele hry
*/

class CPlayButton : public IDrawable
{
	public:
		/** Konstruktor
		*	@param position pozice tlacitka
		*	@param size velikost tlacitka
		*/
		CPlayButton(const sf::Vector2f & position, const sf::Vector2f & size);
		~CPlayButton(); ///< Destruktor
		bool checkClicked(const sf::Vector2f& clickLoc) const; ///< Metoda pro kontrolu kliknuti
		void setPosition(const sf::Vector2f &); ///< Setter pozice tlacitka
		void setSize(const sf::Vector2f &);  ///< Setter velikosti tlacitka
		/** Vykreslujici metoda
		*	@param window reference na okno do ktereho se tlacitko vykresluje
		*/
		virtual void draw(sf::RenderWindow & window);
		/** Nastavuje hodnotu tlacitka -> symbol ktery se vykresluje
		*/
		void setPaused(bool paused);
		void switchPaused(); ///< Prehazuje stav tlacitka
	private:
		sf::RectangleShape 		m_shape; 			///< Ohranicujici obdelnik
		sf::RectangleShape 		m_pauseShape;	 	///< Obdelnik pozastaveni
		sf::CircleShape 		m_playShape; 		///< Trojuhelnik probihani hry
		bool 					m_paused = 1; 		//0 - hraje, 1 - pausnuto ///< Hodnota urcujici zda se vykresluje pauseShape nebo playShape
};

#endif // !1

