#include "CPlayButtonView.h"


CPlayButton::CPlayButton(const sf::Vector2f & position, const sf::Vector2f & size)
{
	m_shape.setFillColor(sf::Color::Transparent);
	m_shape.setOutlineColor(sf::Color::Black);
	m_shape.setOutlineThickness(-2);

	setPosition(position);
	setSize(size);

	m_playShape.setPointCount(3);
	m_playShape.setRadius(10);
	m_playShape.setRotation(90);
	m_playShape.setPosition(sf::Vector2f(position.x + (m_shape.getGlobalBounds().width*1.0) / 2 - (m_playShape.getGlobalBounds().width*1.0) / 2 + m_playShape.getGlobalBounds().width, position.y + (m_shape.getGlobalBounds().height*1.0) / 2 - (m_playShape.getGlobalBounds().height*1.0) / 2));
	m_playShape.setFillColor(sf::Color(0,144,0,255));

	m_pauseShape.setSize(sf::Vector2f(15, 15));
	m_pauseShape.setPosition(sf::Vector2f(position.x + (m_shape.getGlobalBounds().width*1.0) / 2 - (m_pauseShape.getGlobalBounds().width*1.0) / 2, position.y + (m_shape.getGlobalBounds().height*1.0) / 2 - (m_pauseShape.getGlobalBounds().height*1.0) / 2 ));
	m_pauseShape.setFillColor(sf::Color::Red);
}


CPlayButton::~CPlayButton()
{

}

bool CPlayButton::checkClicked(const sf::Vector2f& clickLoc) const
{
	//std::cout << "checking coords x: " << clickLoc.x << " y: "<< clickLoc.y << std::endl;
	if (this->m_shape.getGlobalBounds().contains(clickLoc))
	{
		//std::cout << "now it passed!" << std::endl;
		return true;
	}
	return false;
}

void CPlayButton::setPosition(const sf::Vector2f & position)
{
	m_shape.setPosition(position);
}

void CPlayButton::setSize(const sf::Vector2f & size)
{
	m_shape.setSize(size);
}

void CPlayButton::draw(sf::RenderWindow & window)
{
	window.draw(m_shape);
	if (m_paused)
	{
		window.draw(m_pauseShape);
	}
	else
	{
		window.draw(m_playShape);
	}
}

void CPlayButton::setPaused(bool _paused)
{
	m_paused = _paused;
}

void CPlayButton::switchPaused()
{
	if (m_paused)
	{
		m_paused = false;
	}
	else
	{
		m_paused = true;
	}
}
