///////////////////////////////////////////////////////////
//  CMemoryView.h
//  Implementation of the Class CMemoryView
//  Created on:      04-4-2015 11:30:05
//  Original author: Kuba
///////////////////////////////////////////////////////////

#if !defined CMEMORYVIEW_H
#define CMEMORYVIEW_H

#include "CButton.h"
#include "../CComputer.h"

/** Zobrazí vytížení paměti odélníkem ve výřezu. V závislosti na zatížení, obdélník horizontálně roste/zmenšuje se.
 */

class CMemoryView : public IDrawable
{

public:
	CMemoryView(); ///< Prazdny konstruktor
	virtual ~CMemoryView(); ///< Destruktor
	/** Konstruktor s parametry
	*	@param memSize veliksot ohranicujiciho obdelniku
	*	@param position pozice zobrazeni
	*	@param used vyuziti
	*	@param capacity maximum dostupne
	*	@param font pismo textu
	*	@param usageTextSize velikost textu
	*/
    CMemoryView(const sf::Vector2f & memSize, const sf::Vector2f & position, int used, int capacity,
                const sf::Font & font, unsigned int usageTextSize);
	/** Vykreslujici metoda
	*	@param window reference na okno do ktereho se objekt vykresluje
	*/
    virtual void draw(sf::RenderWindow & window);
	/** Metoda pro aktualizaci zobrazovanych dat
	*	@param comp ukazatel na CComputer obsahujici data
	*/
    void update(CComputer*);
private:
    sf::RectangleShape		m_usedPart; 		///< Obdelnik znazornujici vyuziti
	sf::RectangleShape 		m_border; 			///< Ohranicujici obdelnik
	sf::Text 				m_usage; 			///< Vyuziti textove, format used/capacity
};
#endif // !defined CMEMORYVIEW_H
