///////////////////////////////////////////////////////////
//  CMemoryView.cpp
//  Implementation of the Class CMemoryView
//  Created on:      04-4-2015 11:30:05
//  Original author: Kuba
///////////////////////////////////////////////////////////

#include "CMemoryView.h"
#include <sstream>


CMemoryView::CMemoryView()
{

}



CMemoryView::~CMemoryView()
{

}

CMemoryView::CMemoryView(const sf::Vector2f & memSize, const sf::Vector2f & position, int used, int capacity,
                         const sf::Font & font, unsigned int usageTextSize) :
    m_usedPart(sf::Vector2f((float)used / capacity * memSize.x, memSize.y)), m_border(memSize)
{
    m_usedPart.setPosition(position);
    m_usedPart.setFillColor(sf::Color::Red);
    m_border.setPosition(position);
    m_border.setOutlineColor(sf::Color::Black);
    m_border.setOutlineThickness(1.0);
    m_border.setFillColor(sf::Color::Transparent);
    std::stringstream ss;
    ss << used << "/" << capacity;
    m_usage = sf::Text(ss.str(), font);
    m_usage.setCharacterSize(usageTextSize);
    m_usage.setColor(sf::Color::Black);
    m_usage.setPosition(CMathHelp::FindCenteringPosition(position.x, memSize.x, m_usage.getLocalBounds().width), position.y + memSize.y + 2.0);
}

void CMemoryView::draw(sf::RenderWindow & window)
{
    window.draw(m_usedPart);
    window.draw(m_border);
    window.draw(m_usage);
}

void CMemoryView::update(CComputer * comp)
{
    int _load = comp->getMemory();
    int _max = comp->getMaxMemory();
    m_usedPart.setSize(sf::Vector2f((_load*1.0)/(1.0*_max) * m_border.getGlobalBounds().width, m_border.getGlobalBounds().height));
    m_usage.setString(to_string(_load) + "/" + to_string(_max));

}
