///////////////////////////////////////////////////////////
//  CGameGUI.h
//  Implementation of the Class CGameGUI
//  Created on:      04-4-2015 11:30:04
//  Original author: Kuba
///////////////////////////////////////////////////////////

#if !defined(EA_0860F165_6680_4aa3_AB94_A59358BF71A9__INCLUDED_)
#define EA_0860F165_6680_4aa3_AB94_A59358BF71A9__INCLUDED_

#include "CMemoryView.h"
#include "CCoreSetView.h"
#include "CTaskListRunningView.h"
#include "CTaskListSpawnedView.h"
#include "../CComputer.h"
#include "CPlayButtonView.h"
#include "CDependencyView.h"


class CGameGUI;

class CTestGameGUI {
public:
	void runTests();
	CTestGameGUI();
	~CTestGameGUI();
private:
	//CGameGUI *						testGUI;
	CTestTaskListRunningView *		testRunning;
	CTestTaskListSpawnedView *		testSpawned;
	//void testDependencies();
};


/** Zaobaluje celé okno aplikace s jejímy grafickými komponentami
 */
class CGameGUI
{
	friend class CTestGameGUI;
public:
	virtual ~CGameGUI(); ///< Destruktor
	/** Konstruktor s parametry
		@param windowSize rozmery okna v pixelech, implicitne 1000x600
	*/
    CGameGUI(const sf::Vector2u & windowSize = sf::Vector2u(1000,600));
	/** Inicializacni metoda
		@param comp ukazatel na CComputer obsahujici data pro vykresleni
	*/
	void init(CComputer * comp);
	//sf::Event PlayersAction();
	/** Metoda pro prekresleni GUI
		Nejprve okno vycisti a nasledne vykresli vsechny elementy GUI
	*/
	void refresh();
    void close(); ///< Metoda pro uzavreni okna GUI
	/** Metoda pro kontrolu ktere tlacitko bylo stiksnuto
		@param coords souradnice stisknuti
		@return 0 pro tlacitka uloh, 1 pro stisknuti tlacitka reset, 2 pro stisknuti tlacitka pause/unapuse pozastavujici celou hru, 3 pro stisknuti tlacitka start hry
	*/
    int checkButtons(sf::Vector2i coords);
	/** Metoda aktualizujici vsechny vykreslovana data. Metoda nejprve vymaze vsechny data z elementu a pak je znovu naplni dle dat z ukazatele na CComputer
	*/
    void reload();
	/** Metoda nastavujici vykreslovany cas
		@param time cas pro vykresleni
	*/
    void setTime(std::string time);
    sf::RenderWindow * getWindow(); ///< Getter vracejici odkaz na okno
    sf::RenderWindow & getWindowReference(); ///< Getter vracejici referenci na okno
	/** Metoda vykreslujici obrazovku Konec hry, vytvori ukazatel na tlacitko restart
	*/
	void gameOver();
	void setLost(bool); ///< Setter hodnoty lost
	void setPaused(int); ///< Setter hodnoty pause
	void startScreen();
	/** Metoda vykreslujici Uvodni obrazovku, vytvori ukazatel na tlacitko spustit
	*/
	void setUsername(string); ///< Setter uzivatelskeho jmeno
	void updateDependencies(); ///< Metoda obnovujici zavislosti
private:
    CComputer * 				m_comp;				///< Ukazatel na objekt CComputer
	CCoreSetView * 				m_cores;			///< Ukazatel na objekt zobrazeni sestavy jader
	CMemoryView * 				m_memory;			///< Ukazatel na objekt zobrazeni pameti
	CButton * 					m_resetBtn;			///< Ukazatel na tlacitko restart
	CButton * 					m_startBtn;			///< Ukazatel na tlacitko start
	CPlayButton * 				m_pauseBtn;			///< Ukazatel na tlacitko pozastavit/znovuspustit celou hru
	CTaskListRunningView * 		m_runningTasks;		///< Ukazatel na objekt zobrazeni seznamu bezicich uloh
	sf::Text 					m_score;			///< Text obsahujci skore
	CTaskListSpawnedView * 		m_taskLine; 		///< Ukazatel na objekt zobrazeni fronty uloh
	sf::RenderWindow 			m_window; 			///< Herni okno
	sf::Font 					m_font; 			///< Pismo textu
	sf::Text 					m_time; 			///< Cas
	sf::Text 					m_username; 		///< Uzivatelske jmeno
	bool 						m_lost = 0;  		//0 - hraje, 1 - prohral
	int 						m_paused = 2; 		//0 - hraje, 1 - pausnuto, 2 - username menu
	vector<CDependencyView*> 		m_dependencies; 	///< Vector ukazatelu na zavislosti
	//sf::Event event;


};
#endif // !defined(EA_0860F165_6680_4aa3_AB94_A59358BF71A9__INCLUDED_)
