///////////////////////////////////////////////////////////
//  CGameGUI.cpp
//  Implementation of the Class CGameGUI
//  Created on:      04-4-2015 11:30:04
//  Original author: Kuba
///////////////////////////////////////////////////////////

#include "CGameGUI.h"
#include <sstream>
#include <iostream>

int counter = 0;

CGameGUI::CGameGUI(const sf::Vector2u & windowSize) : m_window(sf::VideoMode(windowSize.x, windowSize.y), "OS Simulator", sf::Style::Titlebar | sf::Style::Close)
{
	m_startBtn = NULL;
	m_pauseBtn = NULL;
	m_resetBtn = NULL;
}


CGameGUI::~CGameGUI()
{
	//delete m_comp;
	delete m_taskLine;
  delete m_runningTasks;
  delete m_cores;
  delete m_memory;
	delete m_resetBtn;
	delete m_startBtn;
	delete m_pauseBtn;
	for (unsigned int i = 0; i < m_dependencies.size(); i++)
	{
		delete m_dependencies.at(i);
	}
}


string toString(int i)
{
    stringstream ss;
    ss << i;
    return ss.str();
}


void CGameGUI::init(CComputer * _comp)
{
	m_comp = _comp;
	m_font.loadFromFile("arial.ttf");
	sf::Vector2u windowSize = this->m_window.getSize();

	m_taskLine = new CTaskListSpawnedView(sf::Vector2f(1.0 / 20 * windowSize.x, 1.5 / 20 * windowSize.y), 9.0 / 20 * windowSize.y, 9.0 / 20 * windowSize.x);
	/** Vytvori frontu cekajicich uloh
	*/
	m_runningTasks = new CTaskListRunningView(sf::Vector2f(1.0 / 20 * windowSize.x, 10.7 / 20 * windowSize.y), 9.0 / 20 * windowSize.y, 9.0 / 20 * windowSize.x);
	/** Vytvori frontu spustenych uloh
	*/
	m_memory = new CMemoryView(sf::Vector2f(7.0 / 20 * windowSize.x, 1.3 / 20 * windowSize.y),
														 sf::Vector2f(12.0 / 20 * windowSize.x, 13.0 / 20 * windowSize.y), 
														 m_comp->getMemory(), m_comp->getMaxMemory(), m_font, 1.0 / 35 * windowSize.y);
	/** Vytvori
	*/
	m_cores = new CCoreSetView(m_comp, windowSize, m_font);

	m_pauseBtn = new CPlayButton(sf::Vector2f(0.2 / 20 * windowSize.x,  0.2 / 20 * windowSize.x), sf::Vector2f(0.5 / 20 * windowSize.x, 0.5 / 20 * windowSize.x));

    m_score.setCharacterSize(15);
    m_score.setFont(m_font);
    m_score.setColor(sf::Color::Black);
    m_score.setString(sf::String("0"));
    m_score.setPosition(sf::Vector2f(1.5 / 20 * windowSize.x, 0.5 / 20 * windowSize.y));

    m_time.setCharacterSize(15);
    m_time.setFont(m_font);
    m_time.setColor(sf::Color::Black);
    m_time.setString("0");
    m_time.setPosition(sf::Vector2f(m_window.getSize().x - m_time.getGlobalBounds().width - 10, 10));

    refresh();
}


int CGameGUI::checkButtons(sf::Vector2i coords) {
	if (m_paused < 2 && m_lost == 0)
	{
		std::vector<CTaskView*> _tasks = m_taskLine->getSpawnedTasks();
		CTaskSpawnedView * spawnedTmp;
		for (unsigned int i = 0; i < _tasks.size(); i++)
		{
			spawnedTmp = dynamic_cast<CTaskSpawnedView*>(_tasks.at(i));
			if (spawnedTmp->checkRunBtn(coords) == true)
			{
				m_comp->runTask(spawnedTmp->getIntID(), spawnedTmp->getThreads());
				break;
			}
			else if (spawnedTmp->checkIncBtn(coords) == true)
			{
				if (spawnedTmp->getThreads() < m_comp->getTaskLine()->at(i)->getNumOfThreads())
					spawnedTmp->increaseThreads();
				break;
			}
			else if (spawnedTmp->checkDecBtn(coords) == true)
			{
				spawnedTmp->decreaseThreads();
				break;
			}
		}

		_tasks = m_runningTasks->getRunningTasks();
		CTaskRunningView * runningTmp;
		for (unsigned int i = 0; i < _tasks.size(); i++)
		{
			runningTmp = dynamic_cast<CTaskRunningView*>(_tasks.at(i));
			if (runningTmp->checkKillBtn(coords) == true)
			{
				m_comp->killTask(runningTmp->getIntID());
				break;
			}
			else if (runningTmp->checkPauseBtn(coords) == true)
			{
				if (runningTmp->checkPause())
				{
					m_comp->unpauseTask(runningTmp->getIntID(), runningTmp->getThreads());
					runningTmp->setPaused(false);
				}
				else
				{
					m_comp->pauseTask(runningTmp->getIntID());
					runningTmp->setPaused(true);
				}
				break;
			}
			else if (runningTmp->checkIncBtn(coords) == true)
			{
				if (runningTmp->getThreads() < m_comp->getRunningTasks()->at(i)->getNumOfThreads())
					runningTmp->increaseThreads();
				break;
			}
			else if (runningTmp->checkDecBtn(coords) == true)
			{
				runningTmp->decreaseThreads();
				break;
			}
		}
	}
	if (m_resetBtn != NULL)
	{
		if (m_lost && m_resetBtn->checkClicked(sf::Vector2f(coords.x, coords.y)))
		{
			m_comp->restart();
			setLost(0);
			return 1;
		}
	}
	if (m_paused < 2 && m_lost == 0)
	{
		if (m_pauseBtn->checkClicked(sf::Vector2f(coords.x, coords.y)))
		{
			m_pauseBtn->switchPaused();
			return 2;
		}
	}

	if (m_startBtn != NULL)
	{
		if (m_startBtn->checkClicked(sf::Vector2f(coords.x, coords.y)))
		{
			m_paused = 1;
			delete m_startBtn;
			return 3;
		}
	}

    refresh();
	return 0;
}


void CGameGUI::refresh()
{
	counter++;

	if (m_paused < 2 && !m_lost)
	{
		reload();
		m_window.clear(sf::Color::White);
		m_taskLine->draw(m_window);
		m_runningTasks->draw(m_window);
		m_cores->draw(m_window);
		m_memory->draw(m_window);
		m_pauseBtn->draw(m_window);
		m_window.draw(m_time);
		m_window.draw(m_score);

		for (unsigned int i = 0; i < m_dependencies.size(); i++)
			m_dependencies.at(i)->draw(m_window);

		m_resetBtn = NULL;
	}
	else if (m_lost)
	{
		gameOver();
	}
	else if (m_paused == 2)
	{
		startScreen();
	}
	m_window.display();
}


void CGameGUI::close()
{
    m_window.close();
}


void CGameGUI::reload()
{
    m_taskLine->update(m_comp, m_font);
    m_runningTasks->update(m_comp, m_font);
    m_memory->update(m_comp);
    m_cores->update(m_comp);
    m_score.setString("Skore: " + std::to_string(m_comp->getPoints()));
    m_time.setPosition(sf::Vector2f(m_window.getSize().x - m_time.getGlobalBounds().width - 10, 10));
	updateDependencies();
}


sf::RenderWindow * CGameGUI::getWindow()
{
    return &m_window;
}


sf::RenderWindow & CGameGUI::getWindowReference()
{
    return m_window;
}


void CGameGUI::setTime(std::string cas)
{
    m_time.setString("Cas: " + cas);
}


void CGameGUI::gameOver()
{
	m_window.clear(sf::Color::Red);

	for (unsigned int i = 0; i < m_comp->getRunningTasks()->size(); i++)
	{
		m_comp->pauseTask(m_comp->getRunningTasks()->at(i)->getID());
	}


	sf::Text gameOverText("Konec hry", m_font, 50);
	gameOverText.setColor(sf::Color::Black);
	gameOverText.setPosition(sf::Vector2f((m_window.getSize().x*1.0)/2 - (gameOverText.getLocalBounds().width*1.0)/2, 100));

	sf::Text reachedScore("Dosazene skore: " + to_string(m_comp->getPoints()), m_font, 20);
	reachedScore.setColor(sf::Color::Black);
	reachedScore.setPosition(sf::Vector2f((gameOverText.getGlobalBounds().left*1.0) + (gameOverText.getLocalBounds().width*1.0)/2 - (reachedScore.getGlobalBounds().width*1.0)/2 , gameOverText.getPosition().y + gameOverText.getLocalBounds().height + 20));

	if(m_resetBtn != NULL)
	{
		delete m_resetBtn;
	}

	m_resetBtn = new CButton(sf::Vector2f(0,0), 20, "Restart", m_font, sf::Color::Green);
	m_resetBtn->setSize(sf::Vector2f(m_resetBtn->getShape().getGlobalBounds().width + 10, m_resetBtn->getShape().getGlobalBounds().height + 10));
	m_resetBtn->setPosition(sf::Vector2f((m_window.getSize().x*1.0) / 2 - (m_resetBtn->getShape().getGlobalBounds().width) / 2, reachedScore.getPosition().y + reachedScore.getLocalBounds().height + 30));

	m_resetBtn->draw(m_window);
	m_window.draw(gameOverText);
	m_window.draw(reachedScore);
}


void CGameGUI::setLost(bool _lost)
{
	m_lost = _lost;
}


void CGameGUI::setPaused(int _paused)
{
	m_paused = _paused;
	if (_paused > 0)
	{
		m_pauseBtn->setPaused(true);
	} else
	{
		m_pauseBtn->setPaused(false);
	}
}


void CGameGUI::startScreen()
{
	m_window.clear(sf::Color::White);

	sf::Text simos("SimOS", m_font, 50);
	simos.setColor(sf::Color::Black);
	simos.setPosition(sf::Vector2f((m_window.getSize().x*1.0) / 2 - (simos.getLocalBounds().width*1.0) / 2, 100));

	sf::Text enterUsername("Zadejte jmeno:", m_font, 20);
	enterUsername.setColor(sf::Color::Black);
	enterUsername.setPosition(sf::Vector2f((m_window.getSize().x*1.0) / 2 - enterUsername.getGlobalBounds().width - 10, simos.getGlobalBounds().top + simos.getGlobalBounds().height + 20));

	if(m_startBtn != NULL)
	{
		delete m_startBtn;
	}

	m_startBtn = new CButton(sf::Vector2f(0, 0), 20, "Zacit hru", m_font);
	m_startBtn->setSize(sf::Vector2f(m_startBtn->getShape().getGlobalBounds().width + 10, m_startBtn->getShape().getGlobalBounds().height + 10));
	m_startBtn->setPosition(sf::Vector2f((m_window.getSize().x*1.0) / 2 - (m_startBtn->getShape().getLocalBounds().width*1.0) / 2, enterUsername.getGlobalBounds().top + enterUsername.getGlobalBounds().height + 20));

	m_username.setFont(m_font);
	m_username.setColor(sf::Color::Black);
	m_username.setCharacterSize(20);
	m_username.setPosition(sf::Vector2f((m_window.getSize().x*1.0) / 2 + 10, simos.getGlobalBounds().top + simos.getGlobalBounds().height + 20));

	m_window.draw(simos);
	m_window.draw(enterUsername);
	m_startBtn->draw(m_window);
	m_window.draw(m_username);
}


void CGameGUI::setUsername(string _username)
{
	m_username.setString(_username);
}


void CGameGUI::updateDependencies()
{
	for (unsigned int i = 0; i < m_dependencies.size(); i++)
	{
		delete m_dependencies.at(i);
	}	
	m_dependencies.clear();
	Vector2f a(0,0); 
	Vector2f b(0,0);
	Vector2f c(0,0);
	bool check1 = false;
	bool check2 = false;
	bool check3 = false;
	for (unsigned int i = 0; i < m_comp->getTaskLine()->size(); i++)
	{
		for (unsigned int j = 0; j < m_comp->getTaskLine()->at(i)->getDependences().size(); j++)
		{
			for (int k = 0; k < this->m_taskLine->getCount(); k++)
			{
				if (m_comp->getTaskLine()->at(i)->getID() == this->m_taskLine->getTasks().at(k)->getIntID())
				{
					a.x = 1.0 / 20 * m_window.getSize().x;
					a.y = 1.5 / 20 * m_window.getSize().y + m_taskLine->getNodeHeight() * k + (m_taskLine->getNodeHeight()*1.0) / 2;
					check1 = true;
				}
				if (m_comp->getTaskLine()->at(i)->getDependences().at(j)->getID() == this->m_taskLine->getTasks().at(k)->getIntID())
				{
					c.x = 1.0 / 20 * m_window.getSize().x;
					c.y = 1.5 / 20 * m_window.getSize().y + m_taskLine->getNodeHeight() * k + (m_taskLine->getNodeHeight()*1.0)/2;
					check2 = true;
				}
				if (check1 && check2)
				{
					b.x = 1.0 / 20 * m_window.getSize().x - 30;
					b.y = c.y + ((a.y - c.y)*1.0) / 2;
					m_dependencies.push_back(new CDependencyView(a, b, c));
				}
			}
			for (int l = 0; l < m_runningTasks->getCount(); l++)
			{
				if (m_comp->getTaskLine()->at(i)->getDependences().at(j)->getID() == this->m_runningTasks->getTasks().at(l)->getIntID())
				{
					c.x = 1.0 / 20 * m_window.getSize().x;
					c.y = m_runningTasks->getPosition().y + m_runningTasks->getNodeHeight() * l + (m_runningTasks->getNodeHeight()*1.0) / 2;
					check3 = true;
				}
				if (check1 && check3)
				{
					b.x = 1.0 / 20 * m_window.getSize().x - 30;
					b.y = a.y + ((c.y - a.y)*1.0) / 2;
					m_dependencies.push_back(new CDependencyView(a, b, c));
				}
			}
			check1 = check2 = check3  = false;
		}
	}
}


CTestGameGUI::CTestGameGUI()
{
	//testGUI = new CGameGUI();
	testRunning = new CTestTaskListRunningView();
	testSpawned = new CTestTaskListSpawnedView();
}


CTestGameGUI::~CTestGameGUI()
{
	delete testRunning;
	delete testSpawned;
}


void CTestGameGUI::runTests()
{
	//testDependencies();
	testRunning->runTests();
	testSpawned->runTests();
}

