#ifndef CDEPENDENCY_H
#define CDEPENDENCY_H

#include <SFML/Graphics/VertexArray.hpp>
#include <SFML/Graphics/CircleShape.hpp>
#include "IDrawable.h"

/** Zobrazeni zavislosti
*/


class CDependencyView : public IDrawable
{
	public:
		CDependencyView(); ///< Prazdny konstruktor
		virtual ~CDependencyView(); ///< Destruktor
		/** Vytvori zobrazeni zavislosti
		*	@param a souradnice pocatecniho bodu sipky
		*	@param b souradnice bodu zlomu sipky
		*	@param c souradnice konecneho bodu sipky
		*/
		CDependencyView(sf::Vector2f a, sf::Vector2f b, sf::Vector2f c);
		/** Nastavi souradnice sipky
		*	@param a souradnice pocatecniho bodu sipky
		*	@param b souradnice bodu zlomu sipky
		*	@param c souradnice konecneho bodu sipky
		*/
		void setCoordinates(sf::Vector2f a, sf::Vector2f b, sf::Vector2f c);
		/** Vykreslujici metoda
		*	@param window reference na okno do ktereho se lomena sipka vykresluje
		*/
		virtual void draw(sf::RenderWindow & window);
		//int getVertexCount();
		//sf::VertexArray getVertextArray();
		float getAngle(float y1 = 0, float y2 = 0); ///< Vraci uhel mezi dopadovou carou a okrajem cilem
	private:
		sf::VertexArray 	m_dependency;	///< Lomena cara zavislosti
		sf::CircleShape 	m_arrow;		///< Sipka ukazujici smer zavislosti
};

#endif // CDEPENDENCY_H
