#include "CDependencyView.h"


CDependencyView::CDependencyView()
{
	m_dependency.setPrimitiveType(sf::PrimitiveType::LinesStrip);
	m_dependency.resize(3);
	m_dependency[0].position = sf::Vector2f(0,0);
	m_dependency[1].position = sf::Vector2f(0,0);
	m_dependency[2].position = sf::Vector2f (0,0);
}


CDependencyView::CDependencyView(sf::Vector2f a, sf::Vector2f b, sf::Vector2f c)
{
	m_dependency.setPrimitiveType(sf::PrimitiveType::LinesStrip);
	m_dependency.resize(3);
	m_dependency[0].position.x = a.x;
	m_dependency[0].position.y = a.y;
	m_dependency[1].position.x = b.x;
	m_dependency[1].position.y = b.y;
	m_dependency[2].position.x = c.x;
	m_dependency[2].position.y = c.y;

	m_dependency[0].color = sf::Color::Red;
	m_dependency[1].color = sf::Color::Red;
	m_dependency[2].color = sf::Color::Red;

	m_arrow.setRadius(6);
	m_arrow.setPointCount(3);
	m_arrow.setFillColor(sf::Color::Red);
	m_arrow.setOrigin(sf::Vector2f(m_arrow.getGlobalBounds().width/2, 0));
	m_arrow.setPosition(m_dependency[2].position);
	m_arrow.setRotation(getAngle(m_dependency[1].position.y, m_dependency[2].position.y));
}


void CDependencyView::setCoordinates(sf::Vector2f a, sf::Vector2f b, sf::Vector2f c) 
{
	m_dependency[0].position = a;
	m_dependency[1].position = b;
	m_dependency[2].position = c;
}


void CDependencyView::draw(sf::RenderWindow & window)
{
	window.draw(m_dependency);
	window.draw(m_arrow);
}


CDependencyView::~CDependencyView()
{
	m_dependency.clear();
}


float CDependencyView::getAngle(float y1, float y2)
{
	if (y1 > y2)
		return atan(30.0 / (y1 - y2)) * 180 / 3.1415926;
	else
		return atan(30.0 / (y1 - y2)) * 180 / 3.1415926 - 180;
}

