///////////////////////////////////////////////////////////
//  CCoreView.h
//  Implementation of the Class CCoreView
//  Created on:      04-4-2015 11:30:04
//  Original author: Kuba
///////////////////////////////////////////////////////////

#if !defined CCOREVIEW_H
#define CCOREVIEW_H

#include "CButton.h"

class CCoreView;

class CTestCoreView
{
private:
	CCoreView *		m_testCoreView;
	sf::Font		m_font;
	void testConstructor();
	void testSetLoad();
public:
	CTestCoreView();
	~CTestCoreView();
	void runTests();
};


/** Zobrazí vytížení jádra odélníkem ve výřezu. V závislosti na zatížení, obdélník vertikálně roste/klesá.
 */

class CCoreView : public IDrawable
{
	friend class CTestCoreView;
public:
	CCoreView(); ///< konstruktor
	virtual ~CCoreView(); ///< destruktor
	/** Vytvori obraz jednoho jadra.
	*	@param coreSize urcuje velikost zobrazeni
	*	@param position urcuje pozici
	*	@param used atkualni zatizeni
	*	@param capacity maximalni pocet operaci
	*	@param font pismo pro text
	*	@textSize velikost textu
	*/
    CCoreView(const sf::Vector2f & coreSize, const sf::Vector2f & position, int used, int capacity,
              const sf::Font & font, unsigned int textSize);
	/** Vykreslujici metoda
	*	@param window reference na okno do ktereho se objekt vykresluje
	*/
    virtual void draw(sf::RenderWindow & window);
	/** Nastavi zatizeni
	*	@param load aktualni zatizeni
	*	@param capacity maximalni pocet oepraci
	*/
	void setLoad(int load, int capacity);
private:
    sf::RectangleShape 		m_usedPart;		///< Obedelnik zatizeni
	sf::RectangleShape 		m_border;		///< Ohranicujici obdelnik
	sf::Text 				m_usage;		///< Zatizeni textove, format load/capacity
};
#endif // !defined CCOREVIEW_H
