///////////////////////////////////////////////////////////
//  CCoreView.cpp
//  Implementation of the Class CCoreView
//  Created on:      04-4-2015 11:30:04
//  Original author: Kuba
///////////////////////////////////////////////////////////

#include "CCoreView.h"
#include <sstream>
#include <iostream>


CCoreView::CCoreView()
{

}


CCoreView::~CCoreView()
{

}


CCoreView::CCoreView(const sf::Vector2f & coreSize, const sf::Vector2f & position, int used, int capacity,
                     const sf::Font & font, unsigned int textSize) :
    m_usedPart(sf::Vector2f(coreSize.x, (float)used / capacity * coreSize.y)), m_border(coreSize)
{
		// Uzivana cast    
		m_usedPart.setPosition(sf::Vector2f(position.x, position.y + coreSize.y - m_usedPart.getSize().y)); // Uzivana cast nastaveni pozice
		m_usedPart.setFillColor(sf::Color::Blue);
		// Ramecek
    m_border.setPosition(position);
    m_border.setOutlineColor(sf::Color::Black);
    m_border.setOutlineThickness(1.0);
    m_border.setFillColor(sf::Color::Transparent);
    std::stringstream ss;
    ss << used << "/" << capacity;
    m_usage = sf::Text(ss.str(), font);
    m_usage.setCharacterSize(textSize);
    m_usage.setColor(sf::Color::Black);
    m_usage.setPosition(CMathHelp::FindCenteringPosition(position.x, coreSize.x, m_usage.getLocalBounds().width), position.y + coreSize.y + 2.0);
}


void CCoreView::draw(sf::RenderWindow & window)
{
    window.draw(m_usedPart);
    window.draw(m_border);
    window.draw(m_usage);
}


void CCoreView::setLoad(int _load, int _capacity)
{
	m_usedPart.setSize(sf::Vector2f(m_border.getSize().x,  (1.0*_load)/(1.0*_capacity) * m_border.getSize().y * -1));
	std::stringstream ss;
	ss << _load << "/" << _capacity;
	m_usage.setString(ss.str());
}

CTestCoreView::CTestCoreView()
{
	m_font.loadFromFile("arial.ttf");
	m_testCoreView = NULL;
}

void CTestCoreView::testConstructor()
{
	float x = (float)rand() / (float)(RAND_MAX / 100);
	float y = (float)rand() / (float)(RAND_MAX / 100);
	float width = (float)rand() / (float)(RAND_MAX / 100);
	float height = (float)rand() / (float)(RAND_MAX / 100);
	float load = (float)rand() / (float)(RAND_MAX / 100);
	float max = (float)rand() / (float)(RAND_MAX / 100);

	m_testCoreView = new CCoreView(sf::Vector2f(width, height), sf::Vector2f(x, y), load, max, m_font, 10);
	if (abs(m_testCoreView->m_border.getPosition().x - x) > 1 ||
		abs(m_testCoreView->m_border.getPosition().y - y) > 1 ||
		abs(m_testCoreView->m_border.getSize().y - height) > 1 ||
		abs(m_testCoreView->m_border.getSize().x - width) > 1 ||
		abs(m_testCoreView->m_usedPart.getPosition().x - x) > 1 ||
		abs(m_testCoreView->m_usedPart.getPosition().y - (y - m_testCoreView->m_usedPart.getSize().y + height)) > 1 ||
		abs(m_testCoreView->m_usedPart.getSize().x - width) > 1 ||
		abs(m_testCoreView->m_usedPart.getSize().y - (load / max)*height) > 1)
	{
		std::cout << "CTestCoreView::testConstructor() fail!" << std::endl;
		return;
	}
	std::cout << "CTestCoreView::testConstructor() success!" << std::endl;
}

void CTestCoreView::testSetLoad()
{
	float load = (float)rand() / (float)(RAND_MAX / 100);
	float max = (float)rand() / (float)(RAND_MAX / 100);

	m_testCoreView->setLoad(load, max);
	if ((m_testCoreView->m_usedPart.getSize().y - (load/max) * m_testCoreView->m_border.getSize().y * -1) > 1)
	{
		std::cout << "CTestCoreView::testSetLoad() fail!" << std::endl;
		return;
	}
	std::cout << "CTestCoreView::testSetLoad() success!" << std::endl;
}

void CTestCoreView::runTests()
{
	testConstructor();
	testSetLoad();
}

