#ifndef CCORESETVIEW_H
#define CCORESETVIEW_H


#include "CCoreView.h"
#include "../CComputer.h"


/** Sestava vykresleni jader
*/

class CCoreSetView : public IDrawable
{
    public:
        CCoreSetView(); ///< Prazdny konstruktor
		/** Vytvori sestavu zobrazeni jednotlivych jader
		*	@param comp ukazatel na CComputer obsahujici data
		*	@param windowSize rozmery okna
		*	@param font pismo pro text
		*/
        CCoreSetView(CComputer* comp, Vector2u windowSize, Font& font);
        virtual ~CCoreSetView(); ///< Destruktor
		void init(CComputer* comp, Vector2u windowSize, Font& font);
		/** Vykreslujici metoda
		*	@param window reference na okno do ktereho se sestava jader vykresluje
		*/
        virtual void draw(sf::RenderWindow & window);
		/** Metoda pro inicializaci sestavy jednoho jadra
		*	@param comp ukazatel na CComputer obsahujici data
		*	@param windowSize rozmery okna
		*	@param font pismo pro text
		*/
		void initOneCore(CComputer* comp, Vector2u windowSize, Font& font);
		/** Metoda pro inicializaci sestavy dvou jader
		*	@param comp ukazatel na CComputer obsahujici data
		*	@param windowSize rozmery okna
		*	@param font pismo pro text
		*/
		void initTwoCores(CComputer* comp, Vector2u windowSize, Font& font);
		/** Metoda pro inicializaci sestavy ctyr jader
		*	@param comp ukazatel na CComputer obsahujici data
		*	@param windowSize rozmery okna
		*	@param font pismo pro text
		*/
		void initFourCores(CComputer* comp, Vector2u windowSize, Font& font);
		/** Metoda pro aktualizaci zobrazovanych dat
		*	@param comp ukazatel na CComputer obsahujici data
		*/
		void update(CComputer* comp);
    protected:
    private:
        vector<CCoreView*> m_cores; ///< vector zobrazeni jader
};


#endif // CCORESETVIEW_H
