	#include "CCoreSetView.h"
#include <iostream>


CCoreSetView::CCoreSetView()
{
    //ctor
}


CCoreSetView::~CCoreSetView()
{
  for (unsigned int i = 0; i < m_cores.size(); i++)
	{
		delete m_cores.at(i);
	}
}


CCoreSetView::CCoreSetView(CComputer * comp, Vector2u windowSize, Font & font)
{
	switch (comp->getCores().size())
	{
		case 1: initOneCore(comp, windowSize, font); break;
		case 2: initTwoCores(comp, windowSize, font); break;
		case 4: initFourCores(comp, windowSize, font); break;
		default: { std::cerr << "Incorrect number of cores!" << "\nNum of cores: " << comp->getCores().size() << endl << "Allowed numbers are: 1, 2, 4" << endl; exit(EXIT_FAILURE); };
    }
}


void CCoreSetView::init(CComputer * comp, Vector2u windowSize, Font & font) 
{
	switch (comp->getCores().size())
	{
		case 1: initOneCore(comp, windowSize, font); break;
		case 2: initTwoCores(comp, windowSize, font); break;
		case 4: initFourCores(comp, windowSize, font); break;
		default: { std::cerr << "Incorrect number of cores!" << "\nNum of cores: " << comp->getCores().size() << endl << "Allowed numbers are: 1, 2, 4" << endl; exit(EXIT_FAILURE); };
	}
}


void CCoreSetView::initOneCore(CComputer * comp, Vector2u windowSize, Font & font) 
{
    if (!m_cores.empty())
		m_cores.clear();
    m_cores.push_back(new CCoreView(sf::Vector2f(7.0/20 * windowSize.x, 9.0/20 * windowSize.y), sf::Vector2f(12.0/20 * windowSize.x, 1.0/20 * windowSize.y), 0, comp->getMaxFreq(), font, 1.0/35 * windowSize.y));
}


void CCoreSetView::initTwoCores(CComputer * comp, Vector2u windowSize, Font & font) 
{
	if (!m_cores.empty())
		m_cores.clear();
	m_cores.push_back(new CCoreView(sf::Vector2f(2.5 / 20 * windowSize.x, 9.0 / 20 * windowSize.y), sf::Vector2f(12.0 / 20 * windowSize.x, 1.0 / 20 * windowSize.y), 0, comp->getMaxFreq(), font, 1.0 / 35 * windowSize.y));
	m_cores.push_back(new CCoreView(sf::Vector2f(2.5 / 20 * windowSize.x, 9.0 / 20 * windowSize.y), sf::Vector2f(16.5 / 20 * windowSize.x, 1.0 / 20 * windowSize.y), 0, comp->getMaxFreq(), font, 1.0 / 35 * windowSize.y));

}


void CCoreSetView::initFourCores(CComputer * comp, Vector2u windowSize, Font & font) 
{
    if (!m_cores.empty()) {
			for (int i = 0; i < 4; i++) 
			{
				delete m_cores.at(i);
			}
			m_cores.clear();
		}
	m_cores.push_back(new CCoreView(sf::Vector2f(1.0 / 20 * windowSize.x, 9.0 / 20 * windowSize.y), sf::Vector2f(12.0 / 20 * windowSize.x, 1.0 / 20 * windowSize.y), 0, comp->getMaxFreq(), font, 1.0 / 35 * windowSize.y));
	m_cores.push_back(new CCoreView(sf::Vector2f(1.0 / 20 * windowSize.x, 9.0 / 20 * windowSize.y), sf::Vector2f(14.0 / 20 * windowSize.x, 1.0 / 20 * windowSize.y), 0, comp->getMaxFreq(), font, 1.0 / 35 * windowSize.y));
	m_cores.push_back(new CCoreView(sf::Vector2f(1.0 / 20 * windowSize.x, 9.0 / 20 * windowSize.y), sf::Vector2f(16.0 / 20 * windowSize.x, 1.0 / 20 * windowSize.y), 0, comp->getMaxFreq(), font, 1.0 / 35 * windowSize.y));
	m_cores.push_back(new CCoreView(sf::Vector2f(1.0 / 20 * windowSize.x, 9.0 / 20 * windowSize.y), sf::Vector2f(18.0 / 20 * windowSize.x, 1.0 / 20 * windowSize.y), 0, comp->getMaxFreq(), font, 1.0 / 35 * windowSize.y));
}


void CCoreSetView::draw(RenderWindow & window) 
{
    for (unsigned int i=0; i<m_cores.size(); i++)
        m_cores.at(i)->draw(window);
}


void CCoreSetView::update(CComputer* comp) 
{
	for (unsigned int i = 0; i < comp->getCores().size(); i++)
		m_cores.at(i)->setLoad(comp->getCores().at(i), comp->getMaxFreq());
}

