///////////////////////////////////////////////////////////
//  CButton.h
//  Implementation of the Class CButton
//  Created on:      04-4-2015 11:30:03
//  Original author: Kuba
///////////////////////////////////////////////////////////

#if !defined CBUTTON_H
#define CBUTTON_H
#include <string>
#include "IDrawable.h"
#include "CMathHelp.h"
#define BUTTON_BORDER_THICKNESS 2
using namespace sf;

/** Reprezentuje tlačítko se zadaným textem. Text je tesně ohraničen černým rámečkem. Toto ohraničení
 *  také vymezuje prostor pro aktivaci tlačítka kliknutím.
 */

class CButton : public IDrawable
{

public:

	/** Vytvoří popsané tlačítko.
	 * @param position souradnice tlacitka
	 * @param textSize velikost textu v pixelech
	 * @param btnText text tlacitka
	 * @param font pismo textu
	 * @param btnColor barva tlacitka, implicitne pruhledne
	 */
    CButton(const sf::Vector2f & position, unsigned int textSize, const std::string & btnText,
                 const Font & font, const sf::Color btnColor = sf::Color::Transparent);
	
	/** Kontroluje kliknutí
	*	@param clickLoc souradnice kliknuti
	*/
	bool checkClicked(const sf::Vector2f& clickLoc) const;
	sf::RectangleShape getShape() const; ///<Getter ohranicujiciho obdelniku
    sf::Text getText() const; ///<Getter textu tlacitka
	/** Setter barvy textu
	*	@param color barva textu
	*/
    void setTextColor(const sf::Color & color);
	/** Vykreslujici metoda
	*	@param window reference na okno do ktereho se tlacitko vykresluje
	*/
    virtual void draw(sf::RenderWindow & window);
	/** Setter pozice tlacitka
	*	@param position souradnice pozadovane pozice
	*/
    void setPosition(const sf::Vector2f & position);
    void setTouchingBorder(); ///<Nastavi ohranicujici obdelnik tak, aby prilehal tesne k textu
	/** Setter velikosti tlacitka
	*	@param borderSize velikost ohranicujiciho obdelniku
	*/
    void setSize(const sf::Vector2f & borderSize);
	/** Setter velikosti textu
	*	@param charSize pozadovana velikost textu
	*/
    void setCharSize(unsigned int charSize);
private:
	sf::RectangleShape 		m_shape;	///<Ohranicujici obdelnik
	sf::Text				m_text;		///<Text tlacitka
};
#endif // !defined CBUTTON_H
