///////////////////////////////////////////////////////////
//  CButton.cpp
//  Implementation of the Class CButton
//  Created on:      04-4-2015 11:30:03
//  Original author: Kuba
///////////////////////////////////////////////////////////

#include <iostream>
#include "CButton.h"


CButton::CButton(const sf::Vector2f & position, unsigned int textSize, const std::string & btnText,
                 const Font & font, const sf::Color btnColor) :
    m_text(sf::Text(String(btnText), font))
{
    m_shape.setFillColor(btnColor);
    m_shape.setOutlineColor(sf::Color::Black);
    m_shape.setOutlineThickness(((textSize > (unsigned int)20) ? -BUTTON_BORDER_THICKNESS : -(BUTTON_BORDER_THICKNESS/2)));

    m_text.setCharacterSize(textSize);
    m_text.setColor(sf::Color::Black);
    setTouchingBorder();
    setPosition(position);
}


bool CButton::checkClicked(const sf::Vector2f& clickLoc) const
{
    if(this->m_shape.getGlobalBounds().contains(clickLoc))
        return true;
	return false;
}


sf::RectangleShape CButton::getShape() const
{
    return m_shape;
}


sf::Text CButton::getText() const
{
    return m_text;
}


void CButton::setTextColor(const sf::Color & color)
{
    m_text.setColor(color);
}


void CButton::draw(sf::RenderWindow & window)
{
    window.draw(m_shape);
    window.draw(m_text);
}


void CButton::setPosition(const sf::Vector2f & position)
{
    m_text.setPosition(position);
    sf::FloatRect rect = m_text.getGlobalBounds();
    sf::Vector2f borderSize(m_shape.getGlobalBounds().width, m_shape.getGlobalBounds().height);
    float xDif = borderSize.x - rect.width;
    float yDif = borderSize.y - rect.height;
    m_text.setPosition(position.x + xDif / 2, position.y - (rect.top - position.y) + yDif / 2);

    m_shape.setPosition(position);
    m_shape.setSize(borderSize);
}


void CButton::setTouchingBorder()
{
    sf::FloatRect rect = m_text.getGlobalBounds();
    m_shape.setSize(sf::Vector2f(rect.width + -2*m_shape.getOutlineThickness(), rect.height + -2*m_shape.getOutlineThickness()));
}


void CButton::setSize(const sf::Vector2f & borderSize)
{
    sf::FloatRect rect = m_text.getGlobalBounds();
    float xDif = borderSize.x - rect.width;
    float yDif = borderSize.y - rect.height;
    m_shape.setPosition(rect.left - xDif / 2, rect.top - yDif / 2);
    m_shape.setSize(borderSize);
}


void CButton::setCharSize(unsigned int charSize)
{
    m_text.setCharacterSize(charSize);
    setPosition(m_shape.getPosition());
}

