///////////////////////////////////////////////////////////
//  CTaskLine.h
//  Implementation of the Class CTaskLine
//  Created on:      04-4-2015 21:51:59
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#if !defined(CTASKLINE_H)
#define CTASKLINE_H

#include "CGenerator.h"
#include <vector>

class CTaskLine;

class CTestTaskLine
{
private:
	CTaskLine * m_TaskLine;
	void testAdd();
	void testPopAll();
public:
	CTestTaskLine(CTaskLine &taskLine)
	{
		m_TaskLine = &taskLine;
	};
	void runTests();
};

/** Fronta čekajících úloh
 */
class CTaskLine
{
	friend class CTestTaskLine;
public:
	/** Přídání vygenerované úlohy
	 */
	void add();
	/** Přidání existující úlohy
	 * @param a Ukazatel na úlohu
	 */
	void add(CTask * a);
	/** Vymazání úlohy
	 * @param id ID úlohy
	 */
	void pop(int id);
	/** Vymazání všech úloh
	 */
	void popAll ( ) ;
	/** Nastavení parametrů pro generování podle obtížnosti
	 * @param diff Obtížnost
	 * @param freq Maximální počet operací
	 * @param cores Počet jader
	 * @param mem Velikost paměti
	 */
	void setDiff ( unsigned int diff, unsigned int freq, unsigned int cores, unsigned int mem );
	/** Zjišťuje čekající úlohy
	 */
	std::vector<CTask*> * get();
	/** Zjišťuje úlohu podle ID
	 * @param id ID úlohy
	 */
	CTask * getTask(int id);
	/** Nastavení počáteční konfiguraci
	 */
	void restart( ) ;
	
private:
	std::vector<CTask*> m_Line; ///< Seznam čekajících úloh
	unsigned int m_Diff; ///< Obtížnost
	CGenerator m_Generator; ///< Generátor úloh
	int m_Dependence = 0; ///< Pravděpodobnost vytvoření závislostí

};
#endif // !defined(CTASKLINE_H)
