///////////////////////////////////////////////////////////
//  CTaskLine.cpp
//  Implementation of the Class CTaskLine
//  Created on:      04-4-2015 21:51:59
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#include "CTaskLine.h"
#include <cstdlib>
#include <vector>
#include <iostream>

using namespace std;


void CTaskLine::add()
{
	std::vector<CTask*> dep;
	while ( ( rand() % 1000 ) < m_Dependence && m_Line.size() > 0 )
	{ // male procento novych uloh sou zavysle, promena m_Dependence
		CTask * pom = m_Line[ rand() % m_Line.size() ];
		unsigned int i;
		for ( i = 0 ; i < dep.size() ; i++ )
		{
			if ( dep[i] == pom ) break;
		} 
		if ( i == dep.size() ) 
		{
			dep.push_back(pom);
		}
	}
	m_Line.push_back( m_Generator.generate(dep) ); //dep- vektor se zavislostma, vetsinou bude prazdny
}


void CTaskLine::add(CTask * a)
{
	m_Line.push_back( a );
}


void CTaskLine::pop(int id)
{
    unsigned int i;
	for ( i = 0 ; i < m_Line.size() ; i++ ) 
	{
		if ( m_Line[i]->getID() == id ) 
		{
			m_Line.erase(m_Line.begin()+i);
			break;
		}
	}
}


CTask * CTaskLine::getTask(int id)
{
	unsigned int i;
	CTask * ret = NULL;
	for ( i = 0 ; i < m_Line.size() ; i++ ) 
	{
		if ( m_Line[i]->getID() == id ) 
		{
			ret = m_Line[i];
			break;
		}
	}
	return ret;
}


std::vector<CTask*> * CTaskLine::get()
{ // todle je pro GUI
	return &m_Line;
}


void CTaskLine::popAll()
{
	unsigned int i;
	for ( i = 0 ; i < m_Line.size() ; i++ ) 
	{
		delete m_Line[i] ;
	}
	m_Line.clear( );
}


void CTaskLine::setDiff ( unsigned int diff, unsigned int freq, unsigned int cores, unsigned int mem )
{
	unsigned int i, num_start_task = 0;
	m_Generator.setDiff ( diff, freq, cores, mem );
	if ( diff == 1 ) 
	{
		m_Dependence = 100;
		num_start_task = 5;
	}
	else if ( diff == 2 ) 
	{
		m_Dependence = 200;
		num_start_task = 8;
	}
	for ( i = 0 ; i < num_start_task ; i++ )
	{ //na zacatku mam NUM_START_TASK uloh
		add();
	}
}


void CTaskLine::restart()
{
	m_Generator.resetID();
}


void CTestTaskLine::runTests()
{
	//CTaskLine
	testAdd();
	testPopAll();
	
	//CGenerator
	CTestGenerator * generator = new CTestGenerator(m_TaskLine->m_Generator);
	generator->testGenerate();
	delete  generator;
}


void CTestTaskLine::testAdd()
{
	unsigned int i;
	unsigned int j = m_TaskLine->m_Line.size();
	m_TaskLine->add();
	i = m_TaskLine->m_Line.size();
	cout << "CTaskLine/add: ";
	if ((j + 1) == i ) cout << "success!" << endl;
	else cout << "failed!" << endl;		
}


void CTestTaskLine::testPopAll()
{
	unsigned int i;
	m_TaskLine->popAll();
	i = m_TaskLine->m_Line.size();
	cout << "CTaskLine/popAll: ";
	if ( 0 == i ) cout << "success!" << endl;
	else cout << "failed!" << endl;
}
