///////////////////////////////////////////////////////////
//  CTask.h
//  Implementation of the Class CTask
//  Created on:      04-4-2015 21:51:58
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#if !defined(CTASK_H)
#define CTASK_H

#include <vector>
#include <string>

class CTask;

class CTestTask
{
private:
	CTask * m_Task;
public:
	CTestTask(CTask * task)
	{
		m_Task = task;
	};
	void testChangeState();
	
};


/** Třída reprezentující úlohu
 */
class CTask
{
	friend class CTestTask;
public:
	/** Konstruktor
	 * @param ID ID úlohy
	 * @param memory Potřebná paměť
	 * @param name Jméno úlohy
	 * @param numOfThreads Maximální počet vláken
	 * @param priority Priorita
	 * @param processor Počet operací
	 * @param maxsecond Maximální počet operací za sekundu
	 * @param DepList Seznam závislostí
	 */
	CTask(unsigned int ID, int memory, std::string name, int numOfThreads, int priority, int processor, int maxsecond, std::vector<CTask*> &DepList);
	/** Mění stav úlohy
	 * @param state Stav, do kterého chceme přejít
	 * @return true pokud se stav změnil, false stav se nezměnil
	 */
	bool changeState(int state);
	/** Odstranění závislosti
	 * @param dep Dokončená úloha
	 */
	bool deleteDep(CTask * dep);
	/** Počet úloh, které jsou na mě závislé
	 */
	int getSizeOfRef();
	/** Přidání závislosti
	 * @param dep Ukazatel na úlohu
	 */
	void addDep(CTask * dep);
	/** Přidání úlohy, která je závislá
	 * @param ref Ukazatel na úlohu
	 */
	void addRef(CTask * ref);
	/** Zjištění stavu úlohy
	 */
	int getState();
	/** Zjištění ID úlohy
	 */
	int getID();
	/** Zbývající počet operací
	 */
	int getRest();
	/** Maximální počet operací za sekundu
	 */
	int getMaxSecond();
	/** Maximální počet vláken
	 */
	int getNumOfThreads();
	/** Velikost požadované paměti
	 */
	int getMemory();
	/** Zjištění závislostí
	 */
	std::vector<CTask*> getDependences ( ) ;
	/** Zjištění jména úlohy
	 */
	std::string getName();
	/** Zjištění priority
	 */
	int getPriority();
	/** Odečtení hotových operací
	 * @param done Počet hotových operací
	 * @return true úloha je hotová, false úloha neni hotová
	 */
	bool decreaseRest(int done); //vraci true, kdyz je uloha hotova
	/** Resetování úlohy, nastaví zbývající počet operací na výchozí hodnotu
	 */
	void setRest(); //nastavi vychozi pocet operaci pro dokonceni ulohy
	

private:
	const unsigned int m_ID; ///< ID úlohy
	std::vector<CTask*> m_DepList; ///< Seznam úloh, na kterých je daná úloha závislá
	std::vector<CTask*> m_RefList; ///< Seznam úloh, které jsou na téhle závislé
	int m_Memory; ///< Požadovaná paměť
	const std::string m_Name; ///< Jméno úlohy
	const int m_NumOfThreads; ///< Macimální počet vláken
	const int m_Priority; ///< Priorita úlohy
	const int m_Processor; ///< Výchozí hodnota potřebných operací k dokončení
	const int m_MaxSecond; ///< Maximální počet operací za sekundu
	int m_Rest; ///< Zbývající počet operací
	int m_State; ///< Stav úlohy: 0 - čekající, 1 - bežící, 2 - dokončená

};
#endif // !defined(CTASK_H)
