///////////////////////////////////////////////////////////
//  CTask.cpp
//  Implementation of the Class CTask
//  Created on:      04-4-2015 21:51:58
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#include "CTask.h"
#include <iostream>

using namespace std;


CTask::CTask(unsigned int ID, int memory, std::string name, int numOfThreads, int priority, int processor, int maxsecond, std::vector<CTask*> &DepList) : m_ID(ID), 
						m_Memory(memory), m_Name(name), m_NumOfThreads(numOfThreads), m_Priority(priority), m_Processor(processor), m_MaxSecond(maxsecond) 
{
							// hnusnej konstruktor, ale lepsi nez getry a settery na vsechno a nastavovat ot postupne
							// do konstruktoru je predavany vector se zavislostmi
	m_State = 0 ;
	unsigned int i = 0;
	m_Rest = m_Processor;
	for (i = 0; i < DepList.size(); i++) 
	{
		m_DepList.push_back(DepList[i]);
		m_DepList[i]->addRef(this);
	}
}


/**
 * Meni stav procesu
 * Navratova hodnota bool kdyby byl na necem zavisly
 */
bool CTask::changeState(int state)
{
	if ( state == 0 ) 
	{ //pauzuju
		m_State = state;
	}
	else if ( state == 1 )
	{ // kdyz ho chci spustit, tak musim zkontrolovat jestli vector zavislosti je prazdny ( kdyz uloha skonci, vymaze se z uloh, ktere sou na ni zavisle)
		if ( m_DepList.size() > 0 ) return false;	
		m_State = state;
	}			
	else 
	{ //finished, vymazu tuto ulohu ze zavislosti jinych uloh, musim si pamatovat, kdo je na me zavislej
		unsigned int i;
		for ( i = 0 ; i < m_RefList.size() ; i++ ) 
		{
			m_RefList[i]->deleteDep(this);
		}		
	}
	return true;
}


int CTask::getState()
{
	return m_State;
}


int CTask::getID()
{
	return m_ID;
}


int CTask::getMaxSecond()
{
	return m_MaxSecond;
}


int CTask::getMemory()
{
	return m_Memory;
}


int CTask::getNumOfThreads()
{
	return m_NumOfThreads;
}


int CTask::getSizeOfRef()
{
	return m_RefList.size();
}


bool CTask::deleteDep(CTask * dep) 
{
	unsigned int i;
	for ( i = 0 ; i < m_DepList.size() ; i++ )
	{
		if ( m_DepList[i] == dep ) 
		{
			m_DepList.erase(m_DepList.begin() + i );
			return true;
		}
	}
	return false;
}


void CTask::addDep(CTask * dep) 
{
	m_DepList.push_back(dep);
}


void CTask::addRef(CTask * ref)
{
	m_RefList.push_back(ref);
}


std::string CTask::getName() 
{
	return m_Name;
}


int CTask::getPriority()
{
	return m_Priority;
}


bool CTask::decreaseRest(int done) 
{
	m_Rest -= done;
	if ( m_Rest < 1 ) return true;
	return false;
}


void CTask::setRest() 
{
	m_Rest = m_Processor;
}


int CTask::getRest() 
{
	return m_Rest;
}


std::vector<CTask*> CTask::getDependences() 
{
	return m_DepList;
}

void CTestTask::testChangeState()
{
	cout << "CTask/changeState: ";
	if ( m_Task->m_DepList.size() > 0 )
	{
		m_Task->changeState(1);
		if (m_Task->m_State == 0 ) cout << "success!" << endl;
		else cout << "failed!" << endl;	
	}
	else
	{
		m_Task->changeState(1);
		if (m_Task->m_State == 1 ) cout << "success!" << endl;
		else cout << "failed!" << endl;
	}
	
}
