///////////////////////////////////////////////////////////
//  CRunningTasks.h
//  Implementation of the Class CRunningTasks
//  Created on:      04-4-2015 21:51:58
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#if !defined(CRUNNINGTASKS_H)
#define CRUNNINGTASKS_H

#include "CTask.h"
#include <vector>

class CRunningTasks;

class CTestRunningTasks
{
private:
	CRunningTasks * m_RunningTasks;
public:
	CTestRunningTasks(CRunningTasks &rTasks)
	{
		m_RunningTasks = &rTasks;
	};
	void testPause();
	void testUnpause();
};

/**
 * Seznam speštěných a pausnutých úloh
 */
class CRunningTasks
{
	friend class CTestRunningTasks;
public:
	/** Přidání úlohy do seznamu
	 * @param task Ukazatel na úlohu, kterou chceme přidat
     */
	void add(CTask * task);
	/** Pausnutí úlohy.
	 * @param id ID úlohy
     */
	void pause(int id);
	/** Odstranění úlohy.
	 * @param id ID úlohy
     */
	CTask * pop(int id);
	/** Odstranění všech úloh.
     */
	void popAll ( );
	//void finished(int id);
	/** Znovuspuštění úlohy.
	 * @param id ID úlohy
     */
	CTask * unpause(int id);
	/** Získání úloh v seznamu.
     */
	std::vector<CTask*> * get();
	
private:
	std::vector<CTask*> m_Line; ///< Seznam spuštěných a pausnutých úloh

};
#endif // !defined(CRUNNINGTASKS_H)
