///////////////////////////////////////////////////////////
//  CRunningTasks.cpp
//  Implementation of the Class CRunningTasks
//  Created on:      04-4-2015 21:51:58
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#include "CRunningTasks.h"
#include <iostream>

using namespace std;


void CRunningTasks::add(CTask * task)
{
	m_Line.push_back(task);
}


void CRunningTasks::pause(int id)
{
	unsigned int i;
	for (i = 0; i < m_Line.size(); i++)
	{
		if ( m_Line[i]->getID() == id ) 
		{
			m_Line[i]->changeState(0);
			break;
		}
	}
}


CTask * CRunningTasks::pop(int id)
{
	unsigned int i;
	CTask * pom = NULL;
	for (i = 0; i < m_Line.size(); i++ )
	{
		if (m_Line[i]->getID() == id) 
		{
			pom = m_Line[i];
			m_Line.erase(m_Line.begin() + i);
			break;
		}
	}
	return pom;
}


CTask * CRunningTasks::unpause(int id)
{
	unsigned int i;
	CTask * task = NULL;
	for (i = 0; i < m_Line.size(); i++)
	{
		if (m_Line[i]->getID() == id) 
		{
			task = m_Line[i];
			task->changeState(1);
			break;
		}
	}
	return task;
}


std::vector<CTask*> * CRunningTasks::get() 
{ //pro GUI
	return &m_Line;
}


void CRunningTasks::popAll()
{
	unsigned int i;
	for (i = 0; i < m_Line.size(); i++) 
	{
		delete m_Line[i] ;
	}
	m_Line.clear( );
}


void CTestRunningTasks::testPause()
{
	unsigned int id = m_RunningTasks->m_Line[0]->getID();
	m_RunningTasks->pause(id);
	cout << "CRunningTasks/pause: ";
	if ( m_RunningTasks->m_Line[0]->getState() == 0 ) cout << "success!" << endl;
	else cout << "failed!" << endl;	
}


void CTestRunningTasks::testUnpause()
{
	unsigned int id = m_RunningTasks->m_Line[0]->getID();
	m_RunningTasks->unpause(id);
	cout << "CRunningTasks/unpause: ";
	if ( m_RunningTasks->m_Line[0]->getState() == 1 ) cout << "success!" << endl;
	else cout << "failed!" << endl;	
}

