 ///////////////////////////////////////////////////////////
//  CProcessor.cpp
//  Implementation of the Class CProcessor
//  Created on:      04-4-2015 21:51:58
//  Original author: Michael
///////////////////////////////////////////////////////////

#include "CProcessor.h"
#include <algorithm>
#include <iostream>
#include <vector>

using namespace std;

/**
Porovnani zatizeni dvou jader, pouzivano pri sortu
*/

bool loadCompare (SJadro i,SJadro j) 
	{ 
		return (i.load<j.load);
	}

/**
Porovnani prumerne priority na jadre, pouzivano pri sortu
*/
 bool avgPriorCompare (SJadro  i, SJadro j)
{
	return i.avgPrior<j.avgPrior;
		
}





CProcessor::CProcessor(){}


void CProcessor::construct(int numOfCores, int tact){

	 m_numOfCores=numOfCores;
	 m_tact=tact;

	 //naalokuju pole jader a nastavim jim idcka
	 m_cores=new CCore[numOfCores];
	 for (int i = 0; i < numOfCores; ++i)
	 {
	 	m_cores[i].setId(i); // nastavim IDcka jadrum
	 	m_cores[i].setTact(tact); //a tact
	 }

}

CProcessor::~CProcessor(){
	delete [] m_cores;
}



void CProcessor::update(SJadro* & core, int numOfCores)
{

	for (int i = 0; i < numOfCores; ++i)
	{
		core[i].load    =m_cores[core[i].id].getLoad(); //ulozim si load a idcko do pole
		core[i].avgPrior=m_cores[core[i].id].getAvgPriority();

	}

}


bool CProcessor::setLoad(int id, int load,int threads,int priority){

int loadPerCore = load;// int loadPerCore=load/threads;


SJadro* targetCores=new SJadro[m_numOfCores]; // pole do kteryho si zjistim jednotlivy vytizeni jader

	for (int i = 0; i < m_numOfCores; ++i)
	{
		targetCores[i].load    =m_cores[i].getLoad(); //ulozim si load a idcko do pole
		targetCores[i].id      =i;
		targetCores[i].avgPrior=m_cores[i].getAvgPriority();

	}
	std::sort(targetCores,targetCores+m_numOfCores,loadCompare); //sesortim, abych to mel od nejmene vytizenych jader
	bool flag=true;
	for (int i = 0; i < threads; ++i)
	{
		if (flag && (targetCores[0].load < m_tact)) //pokud nejmene vytizene jadro neni vytizene na max
		{
			//CCore::setLoadC (int id,int maxload,int prior)
			m_cores[targetCores[0].id].setLoad(id,loadPerCore,priority);// poustim proces na danem jadre
			
			m_vectorOfIds.push_back(SProcess(id,targetCores[0].id)); // tohle je pro mazani: id procesu a jadro kde bezi
			update(targetCores,m_numOfCores);
			std::sort(targetCores,targetCores+m_numOfCores,loadCompare); //musim znova sesortit
			
			continue;
		}
		else // vsechny jadra jsou vytizene na max
		{
			flag=false;
			update(targetCores,m_numOfCores);
			std::sort(targetCores,targetCores+m_numOfCores,avgPriorCompare); // tentokrat podle prumerne priority
			m_cores[targetCores[0].id].setLoad(id,loadPerCore,priority);
			m_vectorOfIds.push_back(SProcess(id,targetCores[0].id)); // tohle je pro mazani: id procesu a jadro kde bezi
			continue;

		}




	}
	delete [] targetCores;
	return true;


}


/**
Metoda na uvolneni loadu daneho procesu(id)

*/

bool CProcessor::unload(int id)
{
bool flag=false;
for (unsigned int i = 0; i < m_vectorOfIds.size(); ++i)
{
	if(m_vectorOfIds[i].id == id)	
	{
		m_cores[ m_vectorOfIds[i].core ].unload(id);
		m_vectorOfIds.erase(m_vectorOfIds.begin()+i); //smazu z vectoru IDcek
  		i--; //musim snizit i, abych naky prvek nepreskocil
  		flag=true;
	}


}
return flag;

}

/**
Vraci celkove vytizeni/load daneho procesu
*/
int CProcessor::getProcessLoad(int id)
{

	//potrebuju projit vsechny procesy na vsech jadrech a vratit soucet
	int pom=0;
	for (int i = 0; i < m_numOfCores; ++i)
	{
		pom+=m_cores[i].getProcessLoad(id);
	}

	return pom;
	


}
/**
Vraci vektor jader s jejich vytizenim
*/
std::vector<int> CProcessor::getLoad()
{
	std::vector<int> coreLoad;
	for (int i = 0; i < m_numOfCores; ++i)
	{
		coreLoad.push_back(m_cores[i].getLoad());
	}
	return coreLoad;

}


void CTestProcessor::testUnload(){
	vector<int> load;
	m_processor = new CProcessor();
	bool test=true;
	cout << "CProcessor/unload Test:"<<endl;
	//prvni test, jedno jadro
	m_processor->construct(1, 1000);
	m_processor->setLoad(1,500,1, 10);
	m_processor->unload(1);
	load=m_processor->getLoad();
	//load[0]
	if(load[0]!=0) test=false;
	cout<<"Test1: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_processor;

	//druhy test, jedno jadro, dva procesy, jeden vypnu
	
	m_processor=new CProcessor();
	m_processor->construct(1, 1000);
	m_processor->setLoad(1,500,1,10);
	m_processor->setLoad(2,250,1,10);
	m_processor->unload(2);
	load=m_processor->getLoad();
	if(load[0]!=500) test=false;
	cout<<"Test2: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_processor;

	//treti test, jedno jadro dva procesy, load prez max, jeden vypnu
	m_processor=new CProcessor();
	m_processor->construct(1, 1000);
	m_processor->setLoad(1,500,1,10);
	m_processor->setLoad(2,500,1,10);
	m_processor->setLoad(3,500,1,10);
	m_processor->unload(2);
	load=m_processor->getLoad();
	if(load[0]!=1000) test=false;
	cout<<"Test3: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	delete m_processor;

}

void CTestProcessor::testSetLoad(){
	vector<int> load;
	m_processor=new CProcessor();
	bool test=true;
	cout<<"CProcessor/load Test:"<<endl;
	//prvni test, jedno jadro, jeden proces, nejde prez max
	m_processor->construct(1, 1000);
	m_processor->setLoad(1,500,1,10);
	load=m_processor->getLoad();
	if(load[0]!=500) test=false;
	cout<<"Test1: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_processor;

	//druhy test, jedno jadro, jeden proces, jdu prez max
	m_processor=new CProcessor();
	m_processor->construct(1, 1000);
	m_processor->setLoad(1,1200,1,10);
	load=m_processor->getLoad();
	if(load[0]!=1000) test=false;
	cout<<"Test2: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_processor;

	//treti test, jedno jadro, dva procesy, jdu prez max
	m_processor=new CProcessor();
	m_processor->construct(1, 1000);
	m_processor->setLoad(1,700,1, 10);
	m_processor->setLoad(2,700,1, 10);
	load=m_processor->getLoad();
	if(load[0]!=1000) test=false;
	cout<<"Test3: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_processor;

	//ctvrty test, dve jadro, dva procesy, max obou
	m_processor=new CProcessor();
	m_processor->construct(2, 1000);
	m_processor->setLoad(1,1000,1,10);
	m_processor->setLoad(2,1000,1,10);
	load=m_processor->getLoad();
	if(load[0] != 1000 || load[1] != 1000) test=false;
	cout<<"Test4: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_processor;

	//ctvrty test, ctyri jadra, ctyri procesy, 700 vsechny
	m_processor=new CProcessor();
	m_processor->construct(4, 1000);
	m_processor->setLoad(1,700,1,10);
	m_processor->setLoad(2,700,1,10);
	m_processor->setLoad(3,700,1,10);
	m_processor->setLoad(4,700,1,10);
	load=m_processor->getLoad();
	if(load[0] != 700 || load[1] != 700|| load[2] != 700|| load[3] != 700) test=false;
	cout<<"Test5: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_processor;

}

void CTestProcessor::runTests(){
	testSetLoad();
	testUnload();
}





