///////////////////////////////////////////////////////////
//  CGenerator.h
//  Implementation of the Class CGenerator
//  Created on:      04-4-2015 21:51:56
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#if !defined(CGENERATOR_H)
#define CGENERATOR_H

#include "CTask.h"
#include <vector>
#include <string>

class CGenerator;

class CTestGenerator
{
private:
	CGenerator * m_Generator;
public:
	CTestGenerator(CGenerator  &generator)
	{
		m_Generator = &generator;
	};
	void testGenerate();
};



/** Generátor úloh
 */
class CGenerator
{
	friend class CTestGenerator;
public:
	/** Konstruktor. Načtení jmen úloh.
     */
	CGenerator();
	/** Generuje task
	 * @param dep Vector závislostí
     */
	CTask* generate(std::vector<CTask*> &dep);
	/** Nastavuje generátor podle obtížnosti a parametrů počítače
	 * @param diff Obtížnost
	 * @param freq Maximální frekvence jádra
	 * @param cores Počet jader
	 * @param mem Velikost paměti
     */
	void setDiff ( unsigned int diff, unsigned int freq, unsigned int cores, unsigned int mem );
	/** Resetuje generátor
     */
	void resetID ( ) ;

private:
	std::vector<std::string> m_NameList; ///< List jmen
	unsigned int m_LastID = 0; ///< Poslední použité id
	unsigned int m_Pos = 0; ///< Pozice posledního použitého jména
	unsigned int m_Memory = 0; ///< Maximální pamět
	unsigned int m_Threads = 0; ///< Maximální počet vláken
	unsigned int m_Priority = 0; ///< Maximální priorita
	unsigned int m_Processor = 0; ///< Maximální počet operací úlohy
	unsigned int m_Second = 0; ///< Maximální počet operací za sekundu úlohy

};
#endif // !defined(CGENERATOR_H)
