///////////////////////////////////////////////////////////
//  CGenerator.cpp
//  Implementation of the Class CGenerator
//  Created on:      04-4-2015 21:51:56
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#include "CGenerator.h"
#include <time.h>
#include <cstdlib>
#include <iostream>
#include <vector>

using namespace std;



CGenerator::CGenerator()
{ 
	m_NameList.push_back("mys");
	m_NameList.push_back("monitor");
	m_NameList.push_back("hdd");
	m_NameList.push_back("mem");
	m_NameList.push_back("proc");
	m_NameList.push_back("klavesa");
	m_NameList.push_back("vic klaves");
	m_NameList.push_back("tlacitko");
	m_NameList.push_back("nejaka dalsi vec");
	m_NameList.push_back("dalsi");
	m_NameList.push_back("originalni jmeno");
	m_NameList.push_back("dalsi originalni jmeno");
	m_NameList.push_back("nevim");
	m_NameList.push_back("uz");
}


CTask* CGenerator::generate(std::vector<CTask*> &dep)
{	
	// vytvorim novou ulohu, zatim random az na id a jmeno
	CTask * pom = new CTask ( m_LastID, rand() % m_Memory + 1, m_NameList[m_Pos], rand() % m_Threads  + 1, rand () % m_Priority  + 1, rand() % m_Processor + 1, rand() % m_Second + 1, dep );
	m_LastID++;
	m_Pos++;
	if ( m_Pos >= m_NameList.size() ) m_Pos = 0;
    return pom;
}


void CGenerator::setDiff ( unsigned int diff, unsigned int freq, unsigned int cores, unsigned int mem ) 
{
	if (diff == 1) 
	{
		m_Memory = mem/5;
		m_Threads = 2*cores;
		m_Processor = cores*freq*10;
		m_Second = m_Processor/50;
	}
	else if (diff == 2) 
	{
		m_Memory = mem/4;
		m_Threads = cores;
		m_Processor = cores*freq*13;
		m_Second = m_Processor/50;
	}
	m_Priority = 100;
}


void CGenerator::resetID (  ) 
{
	m_LastID = 0;
}


void CTestGenerator::testGenerate()
{
	vector<CTask*> dep;
	CTask * generated = m_Generator->generate(dep);
	cout << "CGenerator/generate: ";
	if ( (unsigned int) generated->getID() == m_Generator->m_LastID - 1 ) cout << "success!" << endl;
	else cout << "failed!" << endl;
}
