///////////////////////////////////////////////////////////
//  CCore.h
//  Implementation of the Class CCore
//  Created on:      04-4-2015 21:51:55
//  Original author: Radek
///////////////////////////////////////////////////////////

#if !defined(EA_9D65C651_4962_4ef8_8775_3EA21515982C__INCLUDED_)
#define EA_9D65C651_4962_4ef8_8775_3EA21515982C__INCLUDED_
#include <vector>



struct SCoreProcess{
	SCoreProcess(int a,int c,int d,int e)
		{
			id 				= a;
			currentLoad 	= c;
			maxLoad 		= d;
			priority 		= e;
		}

	int id;
	int currentLoad;
	int maxLoad;
	int priority;

};

class CCore;

class CTestCore
{
private:
	CCore*  m_core;
	void testUnload();
	void testCalculateLoad();
public:
		CTestCore (){
	
		
	};
	
	void runTests();
	
};

class CCore
{
friend class CTestCore;
public:
	CCore();
	void	setTact(int a);
	void 	setLoad (int id,int maxload,int prior);
	void 	setId(int id);
	int  	getId();
	int  	getLoad();
	bool 	unload(int id);
	void 	calculateLoad();
	float 	getAvgPriority();
	int 	getProcessLoad(int id);
	//void vypis();
	
	virtual ~CCore();

private:
	int m_id;
	int m_workLoad;
	int m_priority;
	int m_tact;
	float m_avgPriority;
	std::vector<SCoreProcess> m_running; //bezici procesy

};
#endif // !defined(EA_9D65C651_4962_4ef8_8775_3EA21515982C__INCLUDED_)

