///////////////////////////////////////////////////////////
//  CCore.cpp
//  Implementation of the Class CCore
//  Created on:      04-4-2015 21:51:55
//  Original author: Michael
///////////////////////////////////////////////////////////

#include "CCore.h"
#include <algorithm>
#include <iostream>
using namespace std;
/**
Porovnavani priorit-slouzi pro sort
*/
bool priorCompare ( SCoreProcess i,SCoreProcess j) 
{ 
	return (i.priority < j.priority); 
}






CCore::CCore(){
	m_id=0;
	m_workLoad=0;
	m_avgPriority=0;
	m_priority=0;
}

void CCore::setTact(int a)
{
	m_tact=a;
}
void CCore::setId(int a)
{
	m_id=a;
}
int  CCore::getId()  {return m_id;}
int  CCore::getLoad(){return m_workLoad;}


/**
Vypocet rozlozeni loadu na jadre
*/
void CCore::calculateLoad()
{

	
	//nejdriv musim zistit jestli vubec zaplni cely procak a bude se muset neco snizovat
	
	int pom = 0;
	for (unsigned int i = 0; i < m_running.size(); ++i)
		{
			
			pom += m_running[i].maxLoad;
		}

	if (m_tact - pom >= 0) // vsechno se vejde bez toho abych resil prioritu
	{
		m_workLoad = pom;
	}
	
	else // procesy koliduji, vsechno se na procak nevejde -musim resit prioritu
	{
		std::sort(m_running.begin(),m_running.end(),priorCompare); // setridim si je podle priority od min do max
		int loadPerPriority = m_tact / m_priority; // jedna jednotka taktu za prioritu
		if(loadPerPriority < 1) loadPerPriority=1; // zajisti, ze proces vzdy alespon minimalne bezi

		pom=0;
		/*	int id;
			int current_load;
			int max_load;
			int priority;*/
		for (unsigned int i = 0; i < m_running.size(); ++i)
		{
			pom += loadPerPriority * m_running[i].priority; // po for cyklu budu mit celkovy load procaku
			m_running[i].currentLoad = loadPerPriority * m_running[i].priority; //nastavuju current load jednotlivym procesum
		}
		m_running[m_running.size()-1].currentLoad += (m_tact - pom); // docasne reseni, protoze pocitam load v intech, dam vsechno zbyvajici na posledni proces
															 // (i kdzy to muze presahnout jeho maxload) abych dosahl toho ze jadro jede fakt na 100 %
															 //mohl bych to tam nedat, nastavit workload=tact a pak by bylo vse ok, a jadro by se tvarilo 
															 // ze jede na 100 %
		m_workLoad=m_tact;
}
}



/**
Nastaveni loadu na jadro
*/
void CCore::setLoad(int id,int maxload,int prior)
{
	//a tady bude nove probihat pusteni procesu
	m_running.push_back(SCoreProcess(id,maxload,maxload,prior)); // pridam ho do vektoru
	m_priority += prior;
	m_avgPriority = (float)m_priority / m_running.size();
	calculateLoad();
	
}

/**
Odstraneni vytizeni daneho procesu(id) z jadra
*/
bool CCore::unload(int processId)
{
bool flag=false;
	for (unsigned int i = 0; i < m_running.size(); ++i)
	{
		if(m_running[i].id == processId)
		{	
			m_priority   -= m_running[i].priority;
			m_avgPriority = (float)m_priority / m_running.size();
			m_running.erase(m_running.begin() + i); //smazu z running
			calculateLoad();
			flag=true;
	
		}
	}
return flag;


}




float CCore::getAvgPriority()	{return m_avgPriority;}

int CCore::getProcessLoad(int processId)
{
	int pom=0;
for (unsigned int i = 0; i < m_running.size(); ++i)
{
	if(m_running[i].id == processId)
		pom += m_running[i].currentLoad;
}
return pom;

}

/*
void CCore::vypis()
{
for (unsigned int i = 0; i < running.size(); ++i)
{
	cout<<"Proces id: "<<running[i].id<<" Cur_load "<<running[i].current_load<<endl;
}

}
*/



CCore::~CCore(){

}


void CTestCore::testUnload(){
	bool test=true;
	m_core=new CCore();
	m_core->setTact(1000);
	m_core->setId(1);
	
	cout << "CCore/unload Test: ";
	//privni tests na pusteni a vypnuti ulohy
	int expectedLoad=m_core->getLoad();
	m_core->setLoad(1,200,10); //pustim novy proces
	m_core->unload(1);
	if(m_core->getLoad()!=expectedLoad) test=false;
	cout<<"Test1: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	test=true;
	delete m_core;

	m_core=new CCore();
	m_core->setTact(1000);
	m_core->setId(1);
	expectedLoad=1000;
	m_core->setLoad(1,1000,10);//pustim dva procesy, co vytezuji jadro na max
	m_core->setLoad(2,1000,10);
	m_core->unload(2);
	if(m_core->getLoad()!=expectedLoad) test=false;	
	cout<<"Test2: ";
	if(test) cout<<"succes"<<endl;
		else cout<<"fail"<<endl;
	delete m_core;

}

void CTestCore::runTests(){
	testUnload();
	
}

