///////////////////////////////////////////////////////////
//  CComputer.h
//  Implementation of the Class CComputer
//  Created on:      04-4-2015 21:51:54
//  Original author: Radek Hlavacek.
///////////////////////////////////////////////////////////

#if !defined(CCOMPUTER_H)
#define CCOMPUTER_H


#include "CMemory.h"
#include "CProcessor.h"
#include "CRunningTasks.h"
#include "CTaskLine.h"
#include <vector>
#include <string>
#include "TTime.h"
#include <iostream>

using namespace std;


class CComputer;

class CTestComputer
{
private:
	CComputer * m_Comp;	
	
	void testRunTask();
	void testPauseTask();
	void testUnpauseTask();
	void testKillTask();
	void testSetName();
	void testNewTask();
	
public:

	CTestComputer ( CComputer * comp ) 
	{
		m_Comp = comp;
	};
	
	void runTests();
	
};



/** Simulace počítače
 */
class CComputer
{
	friend class CTestComputer;
public:
	/** Konstruktor. Přečte konfiguraci ze souboru data/config.
     */
	CComputer();
	/** Destruktor. Zapíše jméno hráče a nejvyšší dosazené skóre do souboru.
     */
	~CComputer();
	/** Zjišťuje zatížení paměti.
     */
	int getMemory(); //pro GUI
	/** Zjišťuje velikost paměti.
     */
	int getMaxMemory(); //pro GUI
	/** Zjišťuje skóre hráče.
     */
	int getPoints(); //pro GUI
	/** Zjišťuje maximální počet operací jednoho jádra.
     */
	int getMaxFreq(); //pro GUI
	/** Zjišťuje zatížení jader.
     */
	std::vector<int> getCores(); //pro GUI
	/** Zjišťuje spuštěné úlohy.
     */
	std::vector<CTask*> * getRunningTasks(); //pro GUI, uvolneni pameti a CGame
	/** Zjišťuje úlohy čekající na spustění.
     */
	std::vector<CTask*> * getTaskLine(); //pro GUI a uvolneni pameti
	/** "Zabije úlohu".
	 * @param id ID úlohy
     */
	void killTask(int id); //pro GUI 
	/** Pausuje úlohu.
	 * @param id ID úlohy
     */
	void pauseTask(int id); //pro GUI
	/** Ukončuje úlohu.
	 * @param id ID úlohy
     */
	void finishedTask(int id);  
	/** Nastaví jméno hráče.
	 * @param name Jméno hráče
     */
	void setName(std::string name); //nastavi GUI
	/** Spustí úlohu.
	 * @param id ID úlohy
	 * @param threads Počet vláken
     */
	bool runTask(int id, int threads = 1); //pro GUI
	/** Spustí pausnutou úlohu.
	 * @param id ID úlohy
	 * @param threads Počet vláken
     */
	bool unpauseTask(int id, int threads = 1); //pro GUI
	/** Vygeneruje nový task.
     */
	void newTask ( );
	/** Zjišťuje jak rychle se provadí daný task.
	 * @param id ID úlohy
     */
	int getProcessLoad ( int id ) ; // jak rychle se provadi dany task
	/** Restartuje hru.
     */
	void restart () ; // nova hra
	/** Zvýší čas hry o sekundu.
     */
	void increaseTime ( ); // pricteni sekundy do herniho casu
	/** Zjišťuje odehraný čas.
     */
	std::string getTime ( );
	/** Přičte bonus za čas hry ke skóre.
     */
	void setScore(); // pridani skore za cas hry
	
private:
	CTaskLine m_TaskLine; ///< Úlohy čekající na spuštění
	CMemory m_Memory; ///< Paměť
	CProcessor m_Processor; ///< Processor
	CRunningTasks m_RunningTasks; ///< Spuštěné a pausnuté úlohy
	int m_Score; ///< Skóre aktuální hry
	int m_MaxScore; ///< Maximální dosažené skóre
	int m_Freq; ///< Frekvence processoru
	int m_Mem; ///< Velikost Paměti
	bool m_First; ///< První hra
	std::string m_Name; ///< Jméno hráče
	TTime m_Time; ///< Čas hry
	int m_Diff; ///< Obtížnost

};
#endif // !defined(CCOMPUTER_H)
