///////////////////////////////////////////////////////////
//  CComputer.cpp
//  Implementation of the Class CComputer
//  Created on:      04-4-2015 21:51:55
//  Original author: Radek Hlavacek
///////////////////////////////////////////////////////////

#include "CComputer.h"
#include <stdlib.h>
#include <string>
#include <fstream>
#include <vector>
#include <iostream>
#include <bitset>
#include "CTask.h"


/**
 * nacteni init souboru a vytvoreni prostredku podle zadani
 */
CComputer::CComputer()
{
	std::string line;
	int cores;
	m_First = true;
	std::ifstream myfile ("data/config");
	if (myfile.is_open())
	{
		unsigned int i = 0;
		while (getline(myfile,line))
		{
		  if (i == 1) m_Mem = std::stoi(line);
		  else if (i == 3) cores = std::stoi(line);
		  else if (i == 5) m_Freq = std::stoi(line);
		  else if (i == 7) m_Diff = std::stoi(line);
		  i++;
		}
		myfile.close();
	}
	else 
	{
		perror("Unable to open file");
		exit(-1);
	}
	//std::cout << m_Diff << std::endl;
	m_TaskLine.setDiff(m_Diff, m_Freq, cores, m_Mem);
	m_Score = 0;
	m_Processor.construct(cores,m_Freq);
	m_Memory.construct(m_Mem);
	m_Name = "noname";
}


CComputer::~CComputer()
{ //uvolneni pameti ( zruseni CTasku v TaskLine a RunningTasks)
	unsigned int i;
	if (m_First) 
	{
		m_MaxScore = m_Score;
	}

	std::vector<CTask*> * tasks = m_TaskLine.get();
	for (i = 0; i < tasks->size(); i++) 
	{
		delete tasks->at(i);
	}
	tasks = m_RunningTasks.get();
	for (i = 0; i < tasks->size(); i++ ) 
	{
		delete tasks->at(i);
	}


	//zapsana skore a jmena do souboru
	std::bitset<16> a(m_MaxScore);
	std::bitset<16> b(m_MaxScore >> 16);
	int kontrolniSoucet = a.count() - b.count(); // pocet jednicek v prvnich 16 bitech odectu od poctu jednicek ve druhych 16 bitech a zapisu v hexa
	
	//std::bitset<32> score( a xor b ); /// musim rozlisit zaporny a kladny cisla, kdyz bude zaporny, po prevodu zpet musim od cisla odecist 4294967296
	std::ofstream myfile ("data/score");
	if (myfile.is_open())
	{
		myfile << m_Name << std::endl;
		if(m_MaxScore < 0) myfile << 1 ; //pro zaporna je pred cislem jednicka
		else myfile << 0; //pro kladna a nulu nula
		myfile << a << b << kontrolniSoucet << std::endl;
		myfile.close();
	}
	else 
	{
		perror("Unable to open file");
		exit(-1);
	}
}


int CComputer::getMemory()
{
	return m_Memory.getMemoryLoad();
}


int CComputer::getMaxMemory()
{
	return m_Mem;
}


int CComputer::getPoints()
{
	return m_Score;
}


int CComputer::getMaxFreq()
{
	return m_Freq;
}


std::vector<int> CComputer::getCores()
{ //getCores je pro GUI, staci vratit vector intu, GUI vic nepotrebuje... zatim
    return m_Processor.getLoad();
}


std::vector<CTask*> *  CComputer::getRunningTasks()
{ //pro GUI
	return m_RunningTasks.get();
}


std::vector<CTask*> *  CComputer::getTaskLine()
{ //pro GUI
    return m_TaskLine.get();
}


void CComputer::killTask(int id)
{
	CTask * pom = m_RunningTasks.pop(id);
	m_Processor.unload(id);
	m_Memory.setMemoryLoad(- pom->getMemory());
	m_Score -= 20 - pom->getPriority()/10;
	if (pom->getSizeOfRef() > 0) 
	{ //kdyz ho uzivatel zabije a jine procesy jsou na nem zavisly, tak se objevy znova ve fronte
		pom->setRest();
		m_TaskLine.add(pom);
	}
	else 
	{
		delete pom;
	}
}


void CComputer::finishedTask(int id)
{
	CTask * pom = m_RunningTasks.pop(id);
	pom->changeState(2); // vymazu zavislosti na tuhle ulohu
	m_Processor.unload(id);
	m_Memory.setMemoryLoad(- pom->getMemory());
	m_Score += 15 + ( m_Diff * 5 ) + pom->getPriority()/10 ;
	delete pom;
}


void CComputer::pauseTask(int id)
{
	m_RunningTasks.pause(id);
	m_Processor.unload(id);
}


bool CComputer::runTask(int id, int threads)
{
	//std::cout << threads << std::endl;
	CTask * task = m_TaskLine.getTask(id);
	//std::cerr << "a sem taky!" << std::endl; // testujici vypis
	if ( task->changeState(1) ) 
	{ // overeni splneni zavislosti
		if (!m_Processor.setLoad( id, task->getMaxSecond(), threads, task->getPriority())) return false;
		if (!m_Memory.setMemoryLoad( task->getMemory()))
		{
			m_Processor.unload( id );
			return false;
		}
		m_TaskLine.pop(id);
		m_RunningTasks.add(task);
		return true;
	}
	return false;
}


bool CComputer::unpauseTask(int id, int threads)
{
	CTask * task = m_RunningTasks.unpause(id);
	if (!m_Processor.setLoad(id, task->getMaxSecond(), threads, task->getPriority())) 
	{
		m_RunningTasks.pause(id);
		return false;
	}
	return true;
}


void CComputer::setName(std::string name)
{
	m_Name = name;
}


void CComputer::newTask()
{
	m_TaskLine.add();
}


int CComputer::getProcessLoad(int id) 
{
	return m_Processor.getProcessLoad(id) ;
}


void CComputer::restart()
{
	unsigned int i, n = 5;
	std::vector<CTask*> * pom = m_RunningTasks.get();
	
	if (m_First || m_Score > m_MaxScore) 
	{
		m_MaxScore = m_Score;
		m_First = false;
	}
	
	m_TaskLine.popAll();
	for ( i = 0 ; i < pom->size() ; i++ ) 
	{
		m_Processor.unload(pom->at(i)->getID() );
		m_Memory.setMemoryLoad(- pom->at(i)->getMemory() );
	}
	m_RunningTasks.popAll();
	if (m_Diff == 2) n = 8;
	m_TaskLine.restart();
	for (i = 0 ; i < n ; i++) 
	{
		m_TaskLine.add();
	}
	m_Score = 0;
	m_Time.reset();
}


void CComputer::increaseTime()
{
	m_Time.increase();
}


std::string CComputer::getTime()
{
	return m_Time.get();
}


void CComputer::setScore()
{
	m_Score += m_Time.getMinutes();
}


void CTestComputer::runTests()
{	
		//CComputer
		testRunTask();
		testPauseTask();
		testUnpauseTask();
		testKillTask();
		testSetName();
		testNewTask();
		
		//CTask
		CTestTask * testTask = new CTestTask(m_Comp->getTaskLine()->at(0));
		testTask->testChangeState();
		delete testTask;
		
		//CRunningTasks
		CTestRunningTasks * rTasks = new CTestRunningTasks(m_Comp->m_RunningTasks);
		rTasks->testPause();
		rTasks->testUnpause();
		delete rTasks;
		
		//CTaskLine a CGenerator
		CTestTaskLine * taskLine = new CTestTaskLine(m_Comp->m_TaskLine);
		taskLine->runTests();
		delete taskLine;
		
		//TTime
		m_Comp->m_Time.increase();
		cout << "TTime/increase: ";
		if (m_Comp->m_Time.m_Seconds == 1 ) cout << "success!" << endl;
		else cout << "failed!" << endl;
		m_Comp->m_Time.reset();
		cout << "TTime/reset: ";
		if (m_Comp->m_Time.m_Seconds == 0 ) cout << "success!" << endl;
		else cout << "failed!" << endl;
		
}


void CTestComputer::testRunTask()
{
	unsigned int j = 0;
	unsigned int i = 0;
	while ( j != 2 )
	{
		if (m_Comp->runTask(i,1)) j++;
		i++;
	}
	i = m_Comp->getRunningTasks()->size();
	cout << "CComputer/runTask: ";
	if (i == j) cout << "success!" << endl;
	else cout << "failed!" << endl;
}


void CTestComputer::testPauseTask()
{
	unsigned int i = m_Comp->getRunningTasks()->at(0)->getID();
	m_Comp->pauseTask(i);
	cout << "CComputer/pauseTask: ";
	if (m_Comp->getProcessLoad(i) == 0 ) cout << "success!" << endl;
	else cout << "failed!" << endl;
}


void CTestComputer::testUnpauseTask()
{
	unsigned int i = m_Comp->getRunningTasks()->at(0)->getID();
	m_Comp->unpauseTask(i,1);
	cout << "CComputer/unpauseTask: ";
	if (m_Comp->getProcessLoad(i) != 0 ) cout << "success!" << endl;
	else cout << "failed!" << endl;
}


void CTestComputer::testKillTask()
{
	unsigned int j;
	unsigned int i = m_Comp->getRunningTasks()->size();
	unsigned int id = m_Comp->getRunningTasks()->at(0)->getID();
	m_Comp->killTask(id);
	j = m_Comp->getRunningTasks()->size();
	cout << "CComputer/killTask: ";
	if (i == j+1 ) cout << "success!" << endl;
	else cout << "failed!" << endl;	
}


void CTestComputer::testSetName()
{
	m_Comp->setName("ffff");
	cout << "CComputer/setName: ";
	if ("ffff" == m_Comp->m_Name ) cout << "success!" << endl;
	else cout << "failed!" << endl;
}


void CTestComputer::testNewTask()
{
	unsigned int j;
	unsigned int i = m_Comp->getTaskLine()->size();
	m_Comp->newTask();
	j = m_Comp->getTaskLine()->size();
	cout << "CComputer/newTask: ";
	if ((i + 1) == j ) cout << "success!" << endl;
	else cout << "failed!" << endl;	
}
